/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.imagepipeline.common.ImageDecodeOptionsBuilder;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ImageDecodeOptions {
    private static final ImageDecodeOptions DEFAULTS = ImageDecodeOptions.newBuilder().build();
    public final int minDecodeIntervalMs;
    public final boolean decodePreviewFrame;
    public final boolean useLastFrameForPreview;
    public final boolean decodeAllFrames;
    public final boolean forceStaticImage;

    public ImageDecodeOptions(ImageDecodeOptionsBuilder b) {
        this.minDecodeIntervalMs = b.getMinDecodeIntervalMs();
        this.decodePreviewFrame = b.getDecodePreviewFrame();
        this.useLastFrameForPreview = b.getUseLastFrameForPreview();
        this.decodeAllFrames = b.getDecodeAllFrames();
        this.forceStaticImage = b.getForceStaticImage();
    }

    public static ImageDecodeOptions defaults() {
        return DEFAULTS;
    }

    public static ImageDecodeOptionsBuilder newBuilder() {
        return new ImageDecodeOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageDecodeOptions that = (ImageDecodeOptions)o;
        if (this.decodePreviewFrame != that.decodePreviewFrame) {
            return false;
        }
        if (this.useLastFrameForPreview != that.useLastFrameForPreview) {
            return false;
        }
        if (this.decodeAllFrames != that.decodeAllFrames) {
            return false;
        }
        return this.forceStaticImage == that.forceStaticImage;
    }

    public int hashCode() {
        int result = this.minDecodeIntervalMs;
        result = 31 * result + (this.decodePreviewFrame ? 1 : 0);
        result = 31 * result + (this.useLastFrameForPreview ? 1 : 0);
        result = 31 * result + (this.decodeAllFrames ? 1 : 0);
        result = 31 * result + (this.forceStaticImage ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format((Locale)null, "%d-%b-%b-%b-%b", this.minDecodeIntervalMs, this.decodePreviewFrame, this.useLastFrameForPreview, this.decodeAllFrames, this.forceStaticImage);
    }
}

