/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.os.Process;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class PriorityThreadFactory
implements ThreadFactory {
    private final int mThreadPriority;
    private final String mPrefix;
    private final boolean mAddThreadNumber;
    private final AtomicInteger mThreadNumber = new AtomicInteger(1);

    public PriorityThreadFactory(int threadPriority) {
        this(threadPriority, "PriorityThreadFactory", true);
    }

    public PriorityThreadFactory(int threadPriority, String prefix, boolean addThreadNumber) {
        this.mThreadPriority = threadPriority;
        this.mPrefix = prefix;
        this.mAddThreadNumber = addThreadNumber;
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        Runnable wrapperRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Process.setThreadPriority((int)PriorityThreadFactory.this.mThreadPriority);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                runnable.run();
            }
        };
        String name = this.mAddThreadNumber ? this.mPrefix + "-" + this.mThreadNumber.getAndIncrement() : this.mPrefix;
        return new Thread(wrapperRunnable, name);
    }
}

