/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.internal.Preconditions;
import java.io.UnsupportedEncodingException;

public class ImageFormatCheckerUtils {
    public static byte[] asciiBytes(String value) {
        Preconditions.checkNotNull((Object)value);
        try {
            return value.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("ASCII not found!", uee);
        }
    }

    public static boolean startsWithPattern(byte[] byteArray, byte[] pattern) {
        return ImageFormatCheckerUtils.hasPatternAt(byteArray, pattern, 0);
    }

    public static boolean hasPatternAt(byte[] byteArray, byte[] pattern, int offset) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkNotNull((Object)pattern);
        if (offset + pattern.length > byteArray.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (byteArray[offset + i] == pattern[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOfPattern(byte[] byteArray, int byteArrayLen, byte[] pattern, int patternLen) {
        Preconditions.checkNotNull((Object)byteArray);
        Preconditions.checkNotNull((Object)pattern);
        if (patternLen > byteArrayLen) {
            return -1;
        }
        byte first = pattern[0];
        int max = byteArrayLen - patternLen;
        for (int i = 0; i <= max; ++i) {
            if (byteArray[i] != first) {
                while (++i <= max && byteArray[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + patternLen - 1;
            int k = 1;
            while (j < end && byteArray[j] == pattern[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    private ImageFormatCheckerUtils() {
    }
}

