/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.image.HasImageMetadata;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class CloseableImage
implements Closeable,
ImageInfo,
HasImageMetadata {
    private static final String TAG = "CloseableImage";
    private Map<String, Object> mExtras = new HashMap<String, Object>();
    private static final String[] mImageExtrasList = new String[]{"encoded_size", "encoded_width", "encoded_height", "uri_source", "image_format", "bitmap_config"};

    public abstract int getSizeInBytes();

    @Override
    public abstract void close();

    public abstract boolean isClosed();

    @Override
    public QualityInfo getQualityInfo() {
        return ImmutableQualityInfo.FULL_QUALITY;
    }

    public boolean isStateful() {
        return false;
    }

    @Override
    @Nonnull
    public Map<String, Object> getExtras() {
        return this.mExtras;
    }

    public void setImageExtras(Map<String, Object> extras) {
        if (extras == null) {
            return;
        }
        for (String extra : mImageExtrasList) {
            Object val = extras.get(extra);
            if (val == null) continue;
            this.mExtras.put(extra, val);
        }
    }

    protected void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        FLog.w((String)TAG, (String)"finalize: %s %x still open.", (Object[])new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

