/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.factory;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.executors.SerialExecutorService;
import com.facebook.imagepipeline.animated.factory.AnimatedFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.core.ExecutorSupplier;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.infer.annotation.Nullsafe;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimatedFactoryProvider {
    private static boolean sImplLoaded;
    @Nullable
    private static AnimatedFactory sImpl;

    @Nullable
    public static AnimatedFactory getAnimatedFactory(PlatformBitmapFactory platformBitmapFactory, ExecutorSupplier executorSupplier, CountingMemoryCache<CacheKey, CloseableImage> backingCache, boolean downscaleFrameToDrawableDimensions, @Nullable ExecutorService serialExecutorService) {
        if (!sImplLoaded) {
            try {
                Class<?> clazz = Class.forName("com.facebook.fresco.animation.factory.AnimatedFactoryV2Impl");
                Constructor<?> constructor = clazz.getConstructor(PlatformBitmapFactory.class, ExecutorSupplier.class, CountingMemoryCache.class, Boolean.TYPE, SerialExecutorService.class);
                sImpl = (AnimatedFactory)constructor.newInstance(platformBitmapFactory, executorSupplier, backingCache, downscaleFrameToDrawableDimensions, serialExecutorService);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sImpl != null) {
                sImplLoaded = true;
            }
        }
        return sImpl;
    }

    static {
        sImpl = null;
    }
}

