/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.common;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.util.HashCodeUtil;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Locale;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class ResizeOptions {
    public static final float DEFAULT_ROUNDUP_FRACTION = 0.6666667f;
    public final int width;
    public final int height;
    public final float maxBitmapSize;
    public final float roundUpFraction;

    @Nullable
    public static ResizeOptions forDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        return new ResizeOptions(width, height);
    }

    @Nullable
    public static ResizeOptions forSquareSize(int size) {
        if (size <= 0) {
            return null;
        }
        return new ResizeOptions(size, size);
    }

    public ResizeOptions(int width, int height) {
        this(width, height, 2048.0f);
    }

    public ResizeOptions(int width, int height, float maxBitmapSize) {
        this(width, height, maxBitmapSize, 0.6666667f);
    }

    public ResizeOptions(int width, int height, float maxBitmapSize, float roundUpFraction) {
        Preconditions.checkArgument((Boolean)(width > 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(height > 0 ? 1 : 0));
        this.width = width;
        this.height = height;
        this.maxBitmapSize = maxBitmapSize;
        this.roundUpFraction = roundUpFraction;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.width, (int)this.height);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ResizeOptions)) {
            return false;
        }
        ResizeOptions that = (ResizeOptions)other;
        return this.width == that.width && this.height == that.height;
    }

    public String toString() {
        return String.format((Locale)null, "%dx%d", this.width, this.height);
    }
}

