/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Map;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public interface CountingMemoryCache<K, V>
extends MemoryCache<K, V>,
MemoryTrimmable {
    @Nullable
    public CloseableReference<V> cache(K var1, CloseableReference<V> var2, EntryStateObserver<K> var3);

    @Nullable
    public CloseableReference<V> reuse(K var1);

    public void maybeEvictEntries();

    public int getInUseSizeInBytes();

    public int getEvictionQueueCount();

    public int getEvictionQueueSizeInBytes();

    public void clear();

    public MemoryCacheParams getMemoryCacheParams();

    public CountingLruMap<K, Entry<K, V>> getCachedEntries();

    public Map<Bitmap, Object> getOtherEntries();

    @VisibleForTesting
    public static class Entry<K, V> {
        public final K key;
        public final CloseableReference<V> valueRef;
        public int clientCount;
        public boolean isOrphan;
        @Nullable
        public final EntryStateObserver<K> observer;
        public int accessCount;
        public int size;

        private Entry(K key, CloseableReference<V> valueRef, @Nullable EntryStateObserver<K> observer, int size) {
            this.key = Preconditions.checkNotNull(key);
            this.valueRef = (CloseableReference)Preconditions.checkNotNull((Object)CloseableReference.cloneOrNull(valueRef));
            this.clientCount = 0;
            this.isOrphan = false;
            this.observer = observer;
            this.accessCount = 0;
            this.size = size;
        }

        @VisibleForTesting
        public static <K, V> Entry<K, V> of(K key, CloseableReference<V> valueRef, @Nullable EntryStateObserver<K> observer) {
            return Entry.of(key, valueRef, -1, observer);
        }

        @VisibleForTesting
        public static <K, V> Entry<K, V> of(K key, CloseableReference<V> valueRef, int size, @Nullable EntryStateObserver<K> observer) {
            return new Entry<K, V>(key, valueRef, observer, size);
        }
    }

    public static interface EntryStateObserver<K> {
        public void onExclusivityChanged(K var1, boolean var2);
    }
}

