/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class CloseableImage
implements Closeable,
ImageInfo {
    private static final String TAG = "CloseableImage";
    private Map<String, Object> mExtras = new HashMap<String, Object>();
    private static final Set<String> mImageExtrasList = new HashSet<String>(Arrays.asList("encoded_size", "encoded_width", "encoded_height", "uri_source", "image_format", "bitmap_config", "is_rounded"));

    public abstract int getSizeInBytes();

    @Override
    public abstract void close();

    public abstract boolean isClosed();

    @Override
    public QualityInfo getQualityInfo() {
        return ImmutableQualityInfo.FULL_QUALITY;
    }

    public boolean isStateful() {
        return false;
    }

    @Override
    public Map<String, Object> getExtras() {
        return this.mExtras;
    }

    public void setImageExtras(@Nullable Map<String, Object> extras) {
        if (extras == null) {
            return;
        }
        for (String extra : mImageExtrasList) {
            Object val = extras.get(extra);
            if (val == null) continue;
            this.mExtras.put(extra, val);
        }
    }

    public void setImageExtra(String extra, Object value) {
        if (mImageExtrasList.contains(extra)) {
            this.mExtras.put(extra, value);
        }
    }

    protected void finalize() throws Throwable {
        if (this.isClosed()) {
            return;
        }
        FLog.w((String)TAG, (String)"finalize: %s %x still open.", (Object[])new Object[]{this.getClass().getSimpleName(), System.identityHashCode(this)});
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

