/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageutils.BitmapUtil;
import java.io.Closeable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0004R9\u0010\b\u001a*\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \n*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/facebook/imagepipeline/cache/AnimationFrames;", "Ljava/io/Closeable;", "map", "", "", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "(Ljava/util/Map;)V", "frames", "Ljava/util/concurrent/ConcurrentHashMap;", "kotlin.jvm.PlatformType", "getFrames", "()Ljava/util/concurrent/ConcurrentHashMap;", "sizeBytes", "getSizeBytes", "()I", "close", "", "getFrame", "frameIndex", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nAnimatedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimatedCache.kt\ncom/facebook/imagepipeline/cache/AnimationFrames\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1855#2,2:93\n*S KotlinDebug\n*F\n+ 1 AnimatedCache.kt\ncom/facebook/imagepipeline/cache/AnimationFrames\n*L\n88#1:93,2\n*E\n"})
public final class AnimationFrames
implements Closeable {
    @NotNull
    private final ConcurrentHashMap<Integer, CloseableReference<Bitmap>> frames;
    private final int sizeBytes;

    /*
     * WARNING - void declaration
     */
    public AnimationFrames(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> map) {
        int n;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.frames = new ConcurrentHashMap<Integer, CloseableReference<Bitmap>>(map);
        Iterable iterable = map.values();
        AnimationFrames animationFrames = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            CloseableReference closeableReference = (CloseableReference)t;
            n = n2;
            boolean bl = false;
            int n3 = it.isValid() ? BitmapUtil.getSizeInBytes((Bitmap)it.get()) : 0;
            n2 = n + n3;
        }
        animationFrames.sizeBytes = n = n2;
    }

    @NotNull
    public final ConcurrentHashMap<Integer, CloseableReference<Bitmap>> getFrames() {
        return this.frames;
    }

    public final int getSizeBytes() {
        return this.sizeBytes;
    }

    @Nullable
    public final CloseableReference<Bitmap> getFrame(int frameIndex) {
        CloseableReference<Bitmap> frame;
        CloseableReference<Bitmap> closeableReference = frame = this.frames.get(frameIndex);
        return (closeableReference != null ? closeableReference.isValid() : false) ? frame : null;
    }

    @Override
    public void close() {
        Collection<CloseableReference<Bitmap>> collection = this.frames.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"frames.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CloseableReference it = (CloseableReference)element$iv;
            boolean bl = false;
            it.close();
        }
        this.frames.clear();
    }
}

