/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0019\u001a\u00020\r*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/imageutils/WebpUtil;", "", "()V", "VP8L_HEADER", "", "VP8X_HEADER", "VP8_HEADER", "compare", "", "what", "", "with", "get2BytesAsInt", "", "stream", "Ljava/io/InputStream;", "getHeader", "header", "getInt", "getSize", "Lkotlin/Pair;", "getVP8Dimension", "getVP8LDimension", "getVP8XDimension", "read3Bytes", "getNextByteAsInt", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nWebpUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpUtil.kt\ncom/facebook/imageutils/WebpUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n2624#2,3:183\n*S KotlinDebug\n*F\n+ 1 WebpUtil.kt\ncom/facebook/imageutils/WebpUtil\n*L\n144#1:183,3\n*E\n"})
public final class WebpUtil {
    @NotNull
    public static final WebpUtil INSTANCE = new WebpUtil();
    @NotNull
    private static final String VP8_HEADER = "VP8 ";
    @NotNull
    private static final String VP8L_HEADER = "VP8L";
    @NotNull
    private static final String VP8X_HEADER = "VP8X";

    private WebpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final Pair<Integer, Integer> getSize(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        byte[] headerBuffer = new byte[4];
        try {
            block33: {
                stream.read(headerBuffer);
                if (!INSTANCE.compare(headerBuffer, "RIFF")) {
                    Pair<Integer, Integer> pair = null;
                    return pair;
                }
                INSTANCE.getInt(stream);
                stream.read(headerBuffer);
                if (!INSTANCE.compare(headerBuffer, "WEBP")) {
                    Pair<Integer, Integer> pair = null;
                    return pair;
                }
                stream.read(headerBuffer);
                String string = INSTANCE.getHeader(headerBuffer);
                switch (string.hashCode()) {
                    case 2640730: {
                        if (!string.equals(VP8X_HEADER)) {
                            return null;
                        }
                        break block33;
                    }
                    case 2640718: {
                        if (string.equals(VP8L_HEADER)) break;
                        return null;
                    }
                    case 2640674: {
                        if (!string.equals(VP8_HEADER)) return null;
                        Pair<Integer, Integer> e = INSTANCE.getVP8Dimension(stream);
                        return e;
                    }
                }
                Pair<Integer, Integer> e = INSTANCE.getVP8LDimension(stream);
                return e;
            }
            Pair<Integer, Integer> e = INSTANCE.getVP8XDimension(stream);
            return e;
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private final Pair<Integer, Integer> getVP8Dimension(InputStream stream) throws IOException {
        stream.skip(7L);
        int sign1 = this.getNextByteAsInt(stream);
        int sign2 = this.getNextByteAsInt(stream);
        int sign3 = this.getNextByteAsInt(stream);
        return sign1 != 157 || sign2 != 1 || sign3 != 42 ? null : new Pair((Object)WebpUtil.get2BytesAsInt(stream), (Object)WebpUtil.get2BytesAsInt(stream));
    }

    private final Pair<Integer, Integer> getVP8LDimension(InputStream stream) throws IOException {
        this.getInt(stream);
        int check = this.getNextByteAsInt(stream);
        if (check != 47) {
            return null;
        }
        int data1 = stream.read() & 0xFF;
        int data2 = stream.read() & 0xFF;
        int data3 = stream.read() & 0xFF;
        int data4 = stream.read() & 0xFF;
        int width = ((data2 & 0x3F) << 8 | data1) + 1;
        int height = ((data4 & 0xF) << 10 | data3 << 2 | (data2 & 0xC0) >> 6) + 1;
        return new Pair((Object)width, (Object)height);
    }

    private final Pair<Integer, Integer> getVP8XDimension(InputStream stream) throws IOException {
        stream.skip(8L);
        return new Pair((Object)(this.read3Bytes(stream) + 1), (Object)(this.read3Bytes(stream) + 1));
    }

    private final boolean compare(byte[] what, String with) {
        boolean bl;
        block4: {
            if (what.length != with.length()) {
                return false;
            }
            Iterable $this$none$iv = (Iterable)ArraysKt.getIndices((byte[])what);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!((byte)with.charAt(i) != what[i])) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getHeader(byte[] header) {
        StringBuilder str = new StringBuilder();
        int n = header.length;
        for (int i = 0; i < n; ++i) {
            str.append((char)(UShort.constructor-impl((short)header[i]) & 0xFFFF));
        }
        String string = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
        return string;
    }

    private final int getInt(InputStream stream) throws IOException {
        int byte1 = this.getNextByteAsInt(stream);
        int byte2 = this.getNextByteAsInt(stream);
        int byte3 = this.getNextByteAsInt(stream);
        int byte4 = this.getNextByteAsInt(stream);
        return byte4 << 24 | byte3 << 16 | byte2 << 8 | byte1;
    }

    @JvmStatic
    public static final int get2BytesAsInt(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        int byte1 = INSTANCE.getNextByteAsInt(stream);
        int byte2 = INSTANCE.getNextByteAsInt(stream);
        return byte2 << 8 | byte1;
    }

    private final int read3Bytes(InputStream stream) throws IOException {
        int byte1 = this.getNextByteAsInt(stream);
        int byte2 = this.getNextByteAsInt(stream);
        int byte3 = this.getNextByteAsInt(stream);
        return byte3 << 16 | byte2 << 8 | byte1;
    }

    private final int getNextByteAsInt(InputStream $this$getNextByteAsInt) throws IOException {
        return $this$getNextByteAsInt.read() & 0xFF;
    }
}

