/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatCheckerUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/facebook/imageformat/DefaultImageFormatChecker;", "Lcom/facebook/imageformat/ImageFormat$FormatChecker;", "<init>", "()V", "headerSize", "", "getHeaderSize", "()I", "determineFormat", "Lcom/facebook/imageformat/ImageFormat;", "headerBytes", "", "Companion", "imagepipeline-base_release"})
public final class DefaultImageFormatChecker
implements ImageFormat.FormatChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int headerSize;
    private static final int SIMPLE_WEBP_HEADER_LENGTH = 20;
    private static final int EXTENDED_WEBP_HEADER_LENGTH = 21;
    @NotNull
    private static final byte[] JPEG_HEADER;
    private static final int JPEG_HEADER_LENGTH;
    @NotNull
    private static final byte[] PNG_HEADER;
    private static final int PNG_HEADER_LENGTH;
    @NotNull
    private static final byte[] GIF_HEADER_87A;
    @NotNull
    private static final byte[] GIF_HEADER_89A;
    private static final int GIF_HEADER_LENGTH = 6;
    @NotNull
    private static final byte[] BMP_HEADER;
    private static final int BMP_HEADER_LENGTH;
    @NotNull
    private static final byte[] ICO_HEADER;
    private static final int ICO_HEADER_LENGTH;
    @NotNull
    private static final byte[] HEIF_HEADER_PREFIX;
    @NotNull
    private static final byte[][] HEIF_HEADER_SUFFIXES;
    private static final int HEIF_HEADER_LENGTH = 12;
    @NotNull
    private static final byte[] DNG_HEADER_II;
    @NotNull
    private static final byte[] DNG_HEADER_MM;
    private static final int DNG_HEADER_LENGTH;
    @NotNull
    private static final byte[] BINARY_XML_HEADER;
    private static final int BINARY_XML_HEADER_LENGTH = 4;

    public DefaultImageFormatChecker() {
        Integer[] integerArray = new Integer[]{21, 20, JPEG_HEADER_LENGTH, PNG_HEADER_LENGTH, 6, BMP_HEADER_LENGTH, ICO_HEADER_LENGTH, 12, 4};
        Comparable comparable = ArraysKt.maxOrNull((Comparable[])integerArray);
        if (comparable == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        this.headerSize = ((Number)((Object)comparable)).intValue();
    }

    @Override
    public int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    @NotNull
    public ImageFormat determineFormat(@NotNull byte[] headerBytes, int headerSize) {
        Intrinsics.checkNotNullParameter((Object)headerBytes, (String)"headerBytes");
        if (WebpSupportStatus.isWebpHeader((byte[])headerBytes, (int)0, (int)headerSize)) {
            return DefaultImageFormatChecker.Companion.getWebpFormat(headerBytes, headerSize);
        }
        if (DefaultImageFormatChecker.Companion.isJpegHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.JPEG;
        }
        if (DefaultImageFormatChecker.Companion.isPngHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.PNG;
        }
        if (DefaultImageFormatChecker.Companion.isGifHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.GIF;
        }
        if (DefaultImageFormatChecker.Companion.isBmpHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.BMP;
        }
        if (DefaultImageFormatChecker.Companion.isIcoHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.ICO;
        }
        if (DefaultImageFormatChecker.Companion.isHeifHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.HEIF;
        }
        if (DefaultImageFormatChecker.Companion.isBinaryXmlHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.BINARY_XML;
        }
        return DefaultImageFormatChecker.Companion.isDngHeader(headerBytes, headerSize) ? DefaultImageFormats.DNG : ImageFormat.UNKNOWN;
    }

    static {
        Object object = new byte[]{-1, -40, -1};
        JPEG_HEADER = object;
        JPEG_HEADER_LENGTH = JPEG_HEADER.length;
        object = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        PNG_HEADER = object;
        PNG_HEADER_LENGTH = PNG_HEADER.length;
        GIF_HEADER_87A = ImageFormatCheckerUtils.asciiBytes("GIF87a");
        GIF_HEADER_89A = ImageFormatCheckerUtils.asciiBytes("GIF89a");
        BMP_HEADER = ImageFormatCheckerUtils.asciiBytes("BM");
        BMP_HEADER_LENGTH = BMP_HEADER.length;
        object = new byte[]{0, 0, 1, 0};
        ICO_HEADER = object;
        ICO_HEADER_LENGTH = ICO_HEADER.length;
        HEIF_HEADER_PREFIX = ImageFormatCheckerUtils.asciiBytes("ftyp");
        object = new byte[6][];
        object[0] = (byte)ImageFormatCheckerUtils.asciiBytes("heic");
        object[1] = (byte)ImageFormatCheckerUtils.asciiBytes("heix");
        object[2] = (byte)ImageFormatCheckerUtils.asciiBytes("hevc");
        object[3] = (byte)ImageFormatCheckerUtils.asciiBytes("hevx");
        object[4] = (byte)ImageFormatCheckerUtils.asciiBytes("mif1");
        object[5] = (byte)ImageFormatCheckerUtils.asciiBytes("msf1");
        HEIF_HEADER_SUFFIXES = (byte[][])object;
        object = new byte[]{73, 73, 42, 0};
        DNG_HEADER_II = object;
        object = new byte[]{77, 77, 0, 42};
        DNG_HEADER_MM = object;
        DNG_HEADER_LENGTH = DNG_HEADER_II.length;
        object = new byte[]{3, 0, 8, 0};
        BINARY_XML_HEADER = object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/facebook/imageformat/DefaultImageFormatChecker$Companion;", "", "<init>", "()V", "SIMPLE_WEBP_HEADER_LENGTH", "", "EXTENDED_WEBP_HEADER_LENGTH", "getWebpFormat", "Lcom/facebook/imageformat/ImageFormat;", "imageHeaderBytes", "", "headerSize", "JPEG_HEADER", "JPEG_HEADER_LENGTH", "isJpegHeader", "", "PNG_HEADER", "PNG_HEADER_LENGTH", "isPngHeader", "GIF_HEADER_87A", "GIF_HEADER_89A", "GIF_HEADER_LENGTH", "isGifHeader", "BMP_HEADER", "BMP_HEADER_LENGTH", "isBmpHeader", "ICO_HEADER", "ICO_HEADER_LENGTH", "isIcoHeader", "HEIF_HEADER_PREFIX", "HEIF_HEADER_SUFFIXES", "", "[[B", "HEIF_HEADER_LENGTH", "isHeifHeader", "DNG_HEADER_II", "DNG_HEADER_MM", "DNG_HEADER_LENGTH", "isDngHeader", "BINARY_XML_HEADER", "BINARY_XML_HEADER_LENGTH", "isBinaryXmlHeader", "headerBytes", "imagepipeline-base_release"})
    @SourceDebugExtension(value={"SMAP\nDefaultImageFormatChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultImageFormatChecker.kt\ncom/facebook/imageformat/DefaultImageFormatChecker$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,309:1\n12511#2,2:310\n*S KotlinDebug\n*F\n+ 1 DefaultImageFormatChecker.kt\ncom/facebook/imageformat/DefaultImageFormatChecker$Companion\n*L\n255#1:310,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ImageFormat getWebpFormat(byte[] imageHeaderBytes, int headerSize) {
            if (!WebpSupportStatus.isWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (WebpSupportStatus.isSimpleWebpHeader((byte[])imageHeaderBytes, (int)0)) {
                return DefaultImageFormats.WEBP_SIMPLE;
            }
            if (WebpSupportStatus.isLosslessWebpHeader((byte[])imageHeaderBytes, (int)0)) {
                return DefaultImageFormats.WEBP_LOSSLESS;
            }
            if (WebpSupportStatus.isExtendedWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize)) {
                if (WebpSupportStatus.isAnimatedWebpHeader((byte[])imageHeaderBytes, (int)0)) {
                    return DefaultImageFormats.WEBP_ANIMATED;
                }
                return WebpSupportStatus.isExtendedWebpHeaderWithAlpha((byte[])imageHeaderBytes, (int)0) ? DefaultImageFormats.WEBP_EXTENDED_WITH_ALPHA : DefaultImageFormats.WEBP_EXTENDED;
            }
            return ImageFormat.UNKNOWN;
        }

        private final boolean isJpegHeader(byte[] imageHeaderBytes, int headerSize) {
            return headerSize >= JPEG_HEADER.length && ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, JPEG_HEADER);
        }

        private final boolean isPngHeader(byte[] imageHeaderBytes, int headerSize) {
            return headerSize >= PNG_HEADER.length && ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, PNG_HEADER);
        }

        private final boolean isGifHeader(byte[] imageHeaderBytes, int headerSize) {
            if (headerSize < 6) {
                return false;
            }
            return ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, GIF_HEADER_87A) || ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, GIF_HEADER_89A);
        }

        private final boolean isBmpHeader(byte[] imageHeaderBytes, int headerSize) {
            return headerSize < BMP_HEADER.length ? false : ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, BMP_HEADER);
        }

        private final boolean isIcoHeader(byte[] imageHeaderBytes, int headerSize) {
            return headerSize < ICO_HEADER.length ? false : ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, ICO_HEADER);
        }

        private final boolean isHeifHeader(byte[] imageHeaderBytes, int headerSize) {
            boolean bl;
            block4: {
                if (headerSize < 12) {
                    return false;
                }
                byte boxLength = imageHeaderBytes[3];
                if (boxLength < 8) {
                    return false;
                }
                if (!ImageFormatCheckerUtils.hasPatternAt(imageHeaderBytes, HEIF_HEADER_PREFIX, 4)) {
                    return false;
                }
                Object[] $this$any$iv = (Object[])HEIF_HEADER_SUFFIXES;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    byte[] heifFtype = (byte[])element$iv;
                    boolean bl2 = false;
                    if (!ImageFormatCheckerUtils.hasPatternAt(imageHeaderBytes, heifFtype, 8)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean isDngHeader(byte[] imageHeaderBytes, int headerSize) {
            return headerSize >= DNG_HEADER_LENGTH && (ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, DNG_HEADER_II) || ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, DNG_HEADER_MM));
        }

        private final boolean isBinaryXmlHeader(byte[] headerBytes, int headerSize) {
            return headerSize >= 4 && ImageFormatCheckerUtils.startsWithPattern(headerBytes, BINARY_XML_HEADER);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

