/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

package com.facebook.imagepipeline.nativecode;

import com.facebook.infer.annotation.Nullsafe;
import com.facebook.soloader.nativeloader.NativeLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Single place responsible for loading libimagepipeline.so and its dependencies.
 *
 * <p>If your class has a native method whose implementation lives in libimagepipeline.so then call
 * {@link ImagePipelineNativeLoader#load} in its static initializer: <code>
 *   public class ClassWithNativeMethod {
 *     static {
 *       ImagePipelineNativeLoader.load();
 *     }
 *
 *     private static native void aNativeMethod();
 *   }
 * </code>
 */
@Nullsafe(Nullsafe.Mode.LOCAL)
public class ImagePipelineNativeLoader {
  public static final String DSO_NAME = "imagepipeline";

  public static final List<String> DEPENDENCIES;

  static {
    List<String> dependencies = new ArrayList<String>();
    DEPENDENCIES = Collections.unmodifiableList(dependencies);
  }

  public static void load() {
    NativeLoader.loadLibrary("imagepipeline");
  }
}
