/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.backends.okhttp3;

import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpNetworkFetcher;
import com.facebook.imagepipeline.backends.okhttp3.OkHttpNetworkFetcherException;
import com.facebook.imagepipeline.common.BytesRange;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseNetworkFetcher;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.FetchState;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 /2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002./B#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u001e\u0010\u0010\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J&\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020(H\u0002J \u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher;", "Lcom/facebook/imagepipeline/producers/BaseNetworkFetcher;", "Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher$OkHttpNetworkFetchState;", "callFactory", "Lokhttp3/Call$Factory;", "cancellationExecutor", "Ljava/util/concurrent/Executor;", "disableOkHttpCache", "", "<init>", "(Lokhttp3/Call$Factory;Ljava/util/concurrent/Executor;Z)V", "okHttpClient", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "cacheControl", "Lokhttp3/CacheControl;", "createFetchState", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "Lcom/facebook/imagepipeline/image/EncodedImage;", "context", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "fetch", "", "fetchState", "callback", "Lcom/facebook/imagepipeline/producers/NetworkFetcher$Callback;", "onFetchCompletion", "byteSize", "", "getExtraMap", "", "", "fetchWithRequest", "request", "Lokhttp3/Request;", "makeExceptionFromResponse", "Ljava/io/IOException;", "message", "response", "Lokhttp3/Response;", "handleException", "call", "Lokhttp3/Call;", "e", "Ljava/lang/Exception;", "OkHttpNetworkFetchState", "Companion", "imagepipeline-okhttp3_release"})
@SourceDebugExtension(value={"SMAP\nOkHttpNetworkFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpNetworkFetcher.kt\ncom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1#2:191\n*E\n"})
public class OkHttpNetworkFetcher
extends BaseNetworkFetcher<OkHttpNetworkFetchState> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Call.Factory callFactory;
    @NotNull
    private final Executor cancellationExecutor;
    @Nullable
    private final CacheControl cacheControl;
    @NotNull
    private static final String QUEUE_TIME = "queue_time";
    @NotNull
    private static final String FETCH_TIME = "fetch_time";
    @NotNull
    private static final String TOTAL_TIME = "total_time";
    @NotNull
    private static final String IMAGE_SIZE = "image_size";

    @JvmOverloads
    public OkHttpNetworkFetcher(@NotNull Call.Factory callFactory, @NotNull Executor cancellationExecutor, boolean disableOkHttpCache) {
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)cancellationExecutor, (String)"cancellationExecutor");
        this.callFactory = callFactory;
        this.cancellationExecutor = cancellationExecutor;
        this.cacheControl = disableOkHttpCache ? new CacheControl.Builder().noStore().build() : null;
    }

    public /* synthetic */ OkHttpNetworkFetcher(Call.Factory factory, Executor executor, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(factory, executor, bl);
    }

    public OkHttpNetworkFetcher(@NotNull OkHttpClient okHttpClient) {
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Call.Factory factory = (Call.Factory)okHttpClient;
        ExecutorService executorService = okHttpClient.dispatcher().executorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService(...)");
        this(factory, executorService, false, 4, null);
    }

    @NotNull
    public OkHttpNetworkFetchState createFetchState(@NotNull Consumer<EncodedImage> consumer, @NotNull ProducerContext context) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new OkHttpNetworkFetchState(consumer, context);
    }

    public void fetch(@NotNull OkHttpNetworkFetchState fetchState, @NotNull NetworkFetcher.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)fetchState), (String)"fetchState");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        fetchState.submitTime = SystemClock.elapsedRealtime();
        Uri uri = fetchState.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getUri(...)");
        Uri uri2 = uri;
        try {
            Request.Builder requestBuilder = new Request.Builder().url(uri2.toString()).get();
            CacheControl cacheControl = this.cacheControl;
            if (cacheControl != null) {
                CacheControl p0 = cacheControl;
                boolean bl = false;
                requestBuilder.cacheControl(p0);
            }
            BytesRange bytesRange = fetchState.getContext().getImageRequest().getBytesRange();
            if (bytesRange != null) {
                BytesRange it = bytesRange;
                boolean bl = false;
                requestBuilder.addHeader("Range", it.toHttpRangeHeaderValue());
            }
            Request request = requestBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"build(...)");
            this.fetchWithRequest(fetchState, callback, request);
        }
        catch (Exception e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void onFetchCompletion(@NotNull OkHttpNetworkFetchState fetchState, int byteSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)fetchState), (String)"fetchState");
        fetchState.fetchCompleteTime = SystemClock.elapsedRealtime();
    }

    @Nullable
    public Map<String, String> getExtraMap(@NotNull OkHttpNetworkFetchState fetchState, int byteSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)fetchState), (String)"fetchState");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)QUEUE_TIME, (Object)String.valueOf(fetchState.responseTime - fetchState.submitTime)), TuplesKt.to((Object)FETCH_TIME, (Object)String.valueOf(fetchState.fetchCompleteTime - fetchState.responseTime)), TuplesKt.to((Object)TOTAL_TIME, (Object)String.valueOf(fetchState.fetchCompleteTime - fetchState.submitTime)), TuplesKt.to((Object)IMAGE_SIZE, (Object)String.valueOf(byteSize))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    protected void fetchWithRequest(@NotNull OkHttpNetworkFetchState fetchState, @NotNull NetworkFetcher.Callback callback, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)((Object)fetchState), (String)"fetchState");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Call call = this.callFactory.newCall(request);
        fetchState.getContext().addCallbacks((ProducerContextCallbacks)new BaseProducerContextCallbacks(call, this){
            final /* synthetic */ Call $call;
            final /* synthetic */ OkHttpNetworkFetcher this$0;
            {
                this.$call = $call;
                this.this$0 = $receiver;
            }

            public void onCancellationRequested() {
                if (!Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
                    this.$call.cancel();
                } else {
                    OkHttpNetworkFetcher.access$getCancellationExecutor$p(this.this$0).execute(() -> fetchWithRequest.1.onCancellationRequested$lambda$0(this.$call));
                }
            }

            private static final void onCancellationRequested$lambda$0(Call $call) {
                $call.cancel();
            }
        });
        call.enqueue(new Callback(fetchState, this, callback){
            final /* synthetic */ OkHttpNetworkFetchState $fetchState;
            final /* synthetic */ OkHttpNetworkFetcher this$0;
            final /* synthetic */ NetworkFetcher.Callback $callback;
            {
                this.$fetchState = $fetchState;
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody responseBody;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$fetchState.responseTime = SystemClock.elapsedRealtime();
                ResponseBody responseBody2 = responseBody = response.body();
                if (responseBody2 != null) {
                    Closeable closeable = (Closeable)responseBody2;
                    OkHttpNetworkFetcher okHttpNetworkFetcher = this.this$0;
                    NetworkFetcher.Callback callback = this.$callback;
                    OkHttpNetworkFetchState okHttpNetworkFetchState = this.$fetchState;
                    Throwable throwable = null;
                    try {
                        ResponseBody body = (ResponseBody)closeable;
                        boolean bl = false;
                        try {
                            if (!response.isSuccessful()) {
                                OkHttpNetworkFetcher.access$handleException(okHttpNetworkFetcher, call, OkHttpNetworkFetcher.access$makeExceptionFromResponse(okHttpNetworkFetcher, "Unexpected HTTP code " + response, response), callback);
                            } else {
                                BytesRange responseRange = BytesRange.Companion.fromContentRangeHeader(response.header("Content-Range"));
                                if (responseRange != null && (responseRange.from != 0 || responseRange.to != Integer.MAX_VALUE)) {
                                    okHttpNetworkFetchState.setResponseBytesRange(responseRange);
                                    okHttpNetworkFetchState.setOnNewResultStatusFlags(8);
                                }
                                int contentLength = body.contentLength() < 0L ? 0 : (int)body.contentLength();
                                callback.onResponse(body.byteStream(), contentLength);
                            }
                        }
                        catch (Exception e) {
                            OkHttpNetworkFetcher.access$handleException(okHttpNetworkFetcher, call, e, callback);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                OkHttpNetworkFetcher.access$handleException(this.this$0, call, OkHttpNetworkFetcher.access$makeExceptionFromResponse(this.this$0, "Response body null: " + response, response), this.$callback);
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                OkHttpNetworkFetcher.access$handleException(this.this$0, call, e, this.$callback);
            }
        });
    }

    private final IOException makeExceptionFromResponse(String message, Response response) {
        return Build.VERSION.SDK_INT >= 9 ? new IOException(message, OkHttpNetworkFetcherException.Companion.fromResponse(response)) : new IOException(message);
    }

    private final void handleException(Call call, Exception e, NetworkFetcher.Callback callback) {
        if (call.isCanceled()) {
            callback.onCancellation();
        } else {
            callback.onFailure((Throwable)e);
        }
    }

    @JvmOverloads
    public OkHttpNetworkFetcher(@NotNull Call.Factory callFactory, @NotNull Executor cancellationExecutor) {
        Intrinsics.checkNotNullParameter((Object)callFactory, (String)"callFactory");
        Intrinsics.checkNotNullParameter((Object)cancellationExecutor, (String)"cancellationExecutor");
        this(callFactory, cancellationExecutor, false, 4, null);
    }

    public static final /* synthetic */ Executor access$getCancellationExecutor$p(OkHttpNetworkFetcher $this) {
        return $this.cancellationExecutor;
    }

    public static final /* synthetic */ void access$handleException(OkHttpNetworkFetcher $this, Call call, Exception e, NetworkFetcher.Callback callback) {
        $this.handleException(call, e, callback);
    }

    public static final /* synthetic */ IOException access$makeExceptionFromResponse(OkHttpNetworkFetcher $this, String message, Response response) {
        return $this.makeExceptionFromResponse(message, response);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher$Companion;", "", "<init>", "()V", "QUEUE_TIME", "", "FETCH_TIME", "TOTAL_TIME", "IMAGE_SIZE", "imagepipeline-okhttp3_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/imagepipeline/backends/okhttp3/OkHttpNetworkFetcher$OkHttpNetworkFetchState;", "Lcom/facebook/imagepipeline/producers/FetchState;", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "Lcom/facebook/imagepipeline/image/EncodedImage;", "producerContext", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "<init>", "(Lcom/facebook/imagepipeline/producers/Consumer;Lcom/facebook/imagepipeline/producers/ProducerContext;)V", "submitTime", "", "responseTime", "fetchCompleteTime", "imagepipeline-okhttp3_release"})
    public static final class OkHttpNetworkFetchState
    extends FetchState {
        @JvmField
        public long submitTime;
        @JvmField
        public long responseTime;
        @JvmField
        public long fetchCompleteTime;

        public OkHttpNetworkFetchState(@NotNull Consumer<EncodedImage> consumer, @NotNull ProducerContext producerContext) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)producerContext, (String)"producerContext");
            super(consumer, producerContext);
        }
    }
}

