/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.disk.DefaultDiskStorage;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.DiskStorageSupplier;
import com.facebook.common.file.FileTree;
import com.facebook.common.file.FileUtils;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class DefaultDiskStorageSupplier
implements DiskStorageSupplier {
    private static final Class<?> TAG = DefaultDiskStorageSupplier.class;
    private final int mVersion;
    private final File mRootDirectory;
    private final CacheErrorLogger mCacheErrorLogger;
    @VisibleForTesting
    volatile State mCurrentState;

    public DefaultDiskStorageSupplier(int version, File baseDirectoryPath, String baseDirectoryName, CacheErrorLogger cacheErrorLogger) {
        this.mVersion = version;
        this.mCacheErrorLogger = cacheErrorLogger;
        this.mRootDirectory = new File(baseDirectoryPath, baseDirectoryName);
        this.mCurrentState = new State(null, null);
    }

    @Override
    public synchronized DiskStorage get() throws IOException {
        if (this.shouldCreateNewStorage()) {
            this.deleteOldStorageIfNecessary();
            this.createStorage();
        }
        return (DiskStorage)Preconditions.checkNotNull((Object)this.mCurrentState.storage);
    }

    private boolean shouldCreateNewStorage() {
        State currentState = this.mCurrentState;
        return currentState.storage == null || currentState.rootDirectory == null || !currentState.rootDirectory.exists();
    }

    @VisibleForTesting
    void deleteOldStorageIfNecessary() {
        if (this.mCurrentState.storage != null && this.mCurrentState.rootDirectory != null) {
            FileTree.deleteRecursively((File)this.mCurrentState.rootDirectory);
        }
    }

    private void createStorage() throws IOException {
        this.createRootDirectoryIfNecessary(this.mRootDirectory);
        DefaultDiskStorage storage = new DefaultDiskStorage(this.mRootDirectory, this.mVersion, this.mCacheErrorLogger);
        this.mCurrentState = new State(this.mRootDirectory, storage);
    }

    @VisibleForTesting
    void createRootDirectoryIfNecessary(File rootDirectory) throws IOException {
        try {
            FileUtils.mkdirs((File)rootDirectory);
        }
        catch (FileUtils.CreateDirectoryException cde) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.WRITE_CREATE_DIR, TAG, "createRootDirectoryIfNecessary", cde);
            throw cde;
        }
        FLog.d(TAG, (String)"Created cache directory %s", (Object)rootDirectory.getAbsolutePath());
    }

    @VisibleForTesting
    static class State {
        @Nullable
        public final DiskStorage storage;
        @Nullable
        public final File rootDirectory;

        @VisibleForTesting
        State(@Nullable File rootDirectory, @Nullable DiskStorage storage) {
            this.storage = storage;
            this.rootDirectory = rootDirectory;
        }
    }
}

