/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import com.facebook.binaryresource.BinaryResource;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheErrorLogger;
import com.facebook.cache.common.CacheEventListener;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.DiskStorage;
import com.facebook.cache.disk.DiskStorageSupplier;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.disk.DiskTrimmable;
import com.facebook.common.disk.DiskTrimmableRegistry;
import com.facebook.common.internal.Lists;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.statfs.StatFsHelper;
import com.facebook.common.time.Clock;
import com.facebook.common.time.SystemClock;
import com.facebook.common.util.SecureHashUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DiskStorageCache
implements FileCache,
DiskTrimmable {
    private static final Class<?> TAG = DiskStorageCache.class;
    public static final int START_OF_VERSIONING = 1;
    private static final long FUTURE_TIMESTAMP_THRESHOLD_MS = TimeUnit.HOURS.toMillis(2L);
    private static final long FILECACHE_SIZE_UPDATE_PERIOD_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final double TRIMMING_LOWER_BOUND = 0.02;
    private static final long UNINITIALIZED = -1L;
    private final long mLowDiskSpaceCacheSizeLimit;
    private final long mDefaultCacheSizeLimit;
    private long mCacheSizeLimit;
    private final CacheEventListener mCacheEventListener;
    @GuardedBy(value="mLock")
    private long mCacheSizeLastUpdateTime;
    private final long mCacheSizeLimitMinimum;
    private final StatFsHelper mStatFsHelper;
    private final DiskStorageSupplier mStorageSupplier;
    private final CacheErrorLogger mCacheErrorLogger;
    private final CacheStats mCacheStats;
    private final Clock mClock;
    private final Object mLock = new Object();

    public DiskStorageCache(DiskStorageSupplier diskStorageSupplier, Params params, CacheEventListener cacheEventListener, CacheErrorLogger cacheErrorLogger, @Nullable DiskTrimmableRegistry diskTrimmableRegistry) {
        this.mLowDiskSpaceCacheSizeLimit = params.mLowDiskSpaceCacheSizeLimit;
        this.mDefaultCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mCacheSizeLimit = params.mDefaultCacheSizeLimit;
        this.mStatFsHelper = StatFsHelper.getInstance();
        this.mStorageSupplier = diskStorageSupplier;
        this.mCacheSizeLastUpdateTime = -1L;
        this.mCacheEventListener = cacheEventListener;
        this.mCacheSizeLimitMinimum = params.mCacheSizeLimitMinimum;
        this.mCacheErrorLogger = cacheErrorLogger;
        this.mCacheStats = new CacheStats();
        if (diskTrimmableRegistry != null) {
            diskTrimmableRegistry.registerDiskTrimmable((DiskTrimmable)this);
        }
        this.mClock = SystemClock.get();
    }

    @Override
    public DiskStorage.DiskDumpInfo getDumpInfo() throws IOException {
        return this.mStorageSupplier.get().getDumpInfo();
    }

    @Override
    public boolean isEnabled() {
        try {
            return this.mStorageSupplier.get().isEnabled();
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource getResource(CacheKey key) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                BinaryResource resource = this.mStorageSupplier.get().getResource(this.getResourceId(key), key);
                if (resource == null) {
                    this.mCacheEventListener.onMiss();
                } else {
                    this.mCacheEventListener.onHit();
                }
                return resource;
            }
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "getResource", ioe);
            this.mCacheEventListener.onReadException();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probe(CacheKey key) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this.mStorageSupplier.get().touch(this.getResourceId(key), key);
            }
        }
        catch (IOException e) {
            this.mCacheEventListener.onReadException();
            return false;
        }
    }

    private BinaryResource createTemporaryResource(String resourceId, CacheKey key) throws IOException {
        this.maybeEvictFilesInCacheDir();
        return this.mStorageSupplier.get().createTemporary(resourceId, key);
    }

    private void deleteTemporaryResource(BinaryResource temporaryResource) {
        if (!(temporaryResource instanceof FileBinaryResource)) {
            return;
        }
        FileBinaryResource fileResource = (FileBinaryResource)temporaryResource;
        File tempFile = fileResource.getFile();
        if (tempFile.exists()) {
            FLog.e(TAG, (String)"Temp file still on disk: %s ", (Object[])new Object[]{tempFile});
            if (!tempFile.delete()) {
                FLog.e(TAG, (String)"Failed to delete temp file: %s", (Object[])new Object[]{tempFile});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryResource commitResource(String resourceId, CacheKey key, BinaryResource temporary) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            BinaryResource resource = this.mStorageSupplier.get().commit(resourceId, temporary, key);
            this.mCacheStats.increment(resource.size(), 1L);
            return resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryResource insert(CacheKey key, WriterCallback callback) throws IOException {
        this.mCacheEventListener.onWriteAttempt();
        String resourceId = this.getResourceId(key);
        BinaryResource temporary = this.createTemporaryResource(resourceId, key);
        try {
            this.mStorageSupplier.get().updateResource(resourceId, temporary, callback, key);
            BinaryResource binaryResource = this.commitResource(resourceId, key, temporary);
            this.deleteTemporaryResource(temporary);
            return binaryResource;
        }
        catch (Throwable throwable) {
            try {
                this.deleteTemporaryResource(temporary);
                throw throwable;
            }
            catch (IOException ioe) {
                this.mCacheEventListener.onWriteException();
                FLog.d(TAG, (String)"Failed inserting a file into the cache", (Throwable)ioe);
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(CacheKey key) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mStorageSupplier.get().remove(this.getResourceId(key));
            }
            catch (IOException e) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.DELETE_FILE, TAG, "delete: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clearOldEntries(long cacheExpirationMs) {
        long oldestRemainingEntryAgeMs = 0L;
        Object object = this.mLock;
        synchronized (object) {
            try {
                long now = this.mClock.now();
                DiskStorage storage = this.mStorageSupplier.get();
                Collection<DiskStorage.Entry> allEntries = storage.getEntries();
                int itemsRemovedCount = 0;
                long itemsRemovedSize = 0L;
                for (DiskStorage.Entry entry : allEntries) {
                    long entryAgeMs = Math.max(1L, Math.abs(now - entry.getTimestamp()));
                    if (entryAgeMs >= cacheExpirationMs) {
                        long entryRemovedSize = storage.remove(entry);
                        if (entryRemovedSize <= 0L) continue;
                        ++itemsRemovedCount;
                        itemsRemovedSize += entryRemovedSize;
                        continue;
                    }
                    oldestRemainingEntryAgeMs = Math.max(oldestRemainingEntryAgeMs, entryAgeMs);
                }
                storage.purgeUnexpectedResources();
                if (itemsRemovedCount > 0) {
                    this.maybeUpdateFileCacheSize();
                    this.mCacheStats.increment(-itemsRemovedSize, -itemsRemovedCount);
                    this.reportEviction(CacheEventListener.EvictionReason.CONTENT_STALE, itemsRemovedCount, itemsRemovedSize);
                }
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearOldEntries: " + ioe.getMessage(), ioe);
            }
        }
        return oldestRemainingEntryAgeMs;
    }

    private void reportEviction(CacheEventListener.EvictionReason reason, int itemCount, long itemSize) {
        this.mCacheEventListener.onEviction(reason, itemCount, itemSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeEvictFilesInCacheDir() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            boolean calculatedRightNow = this.maybeUpdateFileCacheSize();
            this.updateFileCacheSizeLimit();
            long cacheSize = this.mCacheStats.getSize();
            if (cacheSize > this.mCacheSizeLimit && !calculatedRightNow) {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
            }
            if (cacheSize > this.mCacheSizeLimit) {
                this.evictAboveSize(this.mCacheSizeLimit * 9L / 10L, CacheEventListener.EvictionReason.CACHE_FULL);
            }
        }
    }

    @GuardedBy(value="mLock")
    private void evictAboveSize(long desiredSize, CacheEventListener.EvictionReason reason) throws IOException {
        Collection<DiskStorage.Entry> entries;
        DiskStorage storage = this.mStorageSupplier.get();
        try {
            entries = this.getSortedEntries(storage.getEntries());
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "evictAboveSize: " + ioe.getMessage(), ioe);
            throw ioe;
        }
        long deleteSize = this.mCacheStats.getSize() - desiredSize;
        int itemCount = 0;
        long sumItemSizes = 0L;
        for (DiskStorage.Entry entry : entries) {
            if (sumItemSizes > deleteSize) break;
            long deletedSize = storage.remove(entry);
            if (deletedSize <= 0L) continue;
            ++itemCount;
            sumItemSizes += deletedSize;
        }
        this.mCacheStats.increment(-sumItemSizes, -itemCount);
        storage.purgeUnexpectedResources();
        this.reportEviction(reason, itemCount, sumItemSizes);
    }

    private Collection<DiskStorage.Entry> getSortedEntries(Collection<DiskStorage.Entry> allEntries) {
        ArrayList entriesList = Lists.newArrayList(allEntries);
        long threshold = this.mClock.now() + FUTURE_TIMESTAMP_THRESHOLD_MS;
        Collections.sort(entriesList, new TimestampComparator(threshold));
        return entriesList;
    }

    @GuardedBy(value="mLock")
    private void updateFileCacheSizeLimit() {
        boolean isAvailableSpaceLowerThanHighLimit = this.mStatFsHelper.testLowDiskSpace(StatFsHelper.StorageType.INTERNAL, this.mDefaultCacheSizeLimit - this.mCacheStats.getSize());
        this.mCacheSizeLimit = isAvailableSpaceLowerThanHighLimit ? this.mLowDiskSpaceCacheSizeLimit : this.mDefaultCacheSizeLimit;
    }

    @Override
    public long getSize() {
        return this.mCacheStats.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mStorageSupplier.get().clearAll();
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "clearAll: " + ioe.getMessage(), ioe);
            }
            this.mCacheStats.reset();
        }
    }

    @Override
    public boolean hasKey(CacheKey key) {
        try {
            return this.mStorageSupplier.get().contains(this.getResourceId(key), key);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToMinimum() {
        Object object = this.mLock;
        synchronized (object) {
            this.maybeUpdateFileCacheSize();
            long cacheSize = this.mCacheStats.getSize();
            if (this.mCacheSizeLimitMinimum <= 0L || cacheSize <= 0L || cacheSize < this.mCacheSizeLimitMinimum) {
                return;
            }
            double trimRatio = 1.0 - (double)this.mCacheSizeLimitMinimum / (double)cacheSize;
            if (trimRatio > 0.02) {
                this.trimBy(trimRatio);
            }
        }
    }

    public void trimToNothing() {
        this.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimBy(double trimRatio) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mCacheStats.reset();
                this.maybeUpdateFileCacheSize();
                long cacheSize = this.mCacheStats.getSize();
                long newMaxBytesInFiles = cacheSize - (long)(trimRatio * (double)cacheSize);
                this.evictAboveSize(newMaxBytesInFiles, CacheEventListener.EvictionReason.CACHE_MANAGER_TRIMMED);
            }
            catch (IOException ioe) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.EVICTION, TAG, "trimBy: " + ioe.getMessage(), ioe);
            }
        }
    }

    @GuardedBy(value="mLock")
    private boolean maybeUpdateFileCacheSize() {
        boolean result = false;
        long now = android.os.SystemClock.elapsedRealtime();
        if (!this.mCacheStats.isInitialized() || this.mCacheSizeLastUpdateTime == -1L || now - this.mCacheSizeLastUpdateTime > FILECACHE_SIZE_UPDATE_PERIOD_MS) {
            this.calcFileCacheSize();
            this.mCacheSizeLastUpdateTime = now;
            result = true;
        }
        return result;
    }

    @GuardedBy(value="mLock")
    private void calcFileCacheSize() {
        long size = 0L;
        int count = 0;
        boolean foundFutureTimestamp = false;
        int numFutureFiles = 0;
        int sizeFutureFiles = 0;
        long maxTimeDelta = -1L;
        long now = this.mClock.now();
        long timeThreshold = now + FUTURE_TIMESTAMP_THRESHOLD_MS;
        try {
            DiskStorage storage = this.mStorageSupplier.get();
            Collection<DiskStorage.Entry> entries = storage.getEntries();
            for (DiskStorage.Entry entry : entries) {
                ++count;
                size += entry.getSize();
                if (entry.getTimestamp() <= timeThreshold) continue;
                foundFutureTimestamp = true;
                ++numFutureFiles;
                sizeFutureFiles = (int)((long)sizeFutureFiles + entry.getSize());
                maxTimeDelta = Math.max(entry.getTimestamp() - now, maxTimeDelta);
            }
            if (foundFutureTimestamp) {
                this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.READ_INVALID_ENTRY, TAG, "Future timestamp found in " + numFutureFiles + " files , with a total size of " + sizeFutureFiles + " bytes, and a maximum time delta of " + maxTimeDelta + "ms", null);
            }
            this.mCacheStats.set(size, count);
        }
        catch (IOException ioe) {
            this.mCacheErrorLogger.logError(CacheErrorLogger.CacheErrorCategory.GENERIC_IO, TAG, "calcFileCacheSize: " + ioe.getMessage(), ioe);
        }
    }

    @VisibleForTesting
    String getResourceId(CacheKey key) {
        try {
            return SecureHashUtil.makeSHA1HashBase64((byte[])key.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TimestampComparator
    implements Comparator<DiskStorage.Entry> {
        private final long threshold;

        public TimestampComparator(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public int compare(DiskStorage.Entry e1, DiskStorage.Entry e2) {
            long time2;
            long time1 = e1.getTimestamp() <= this.threshold ? e1.getTimestamp() : 0L;
            long l = time2 = e2.getTimestamp() <= this.threshold ? e2.getTimestamp() : 0L;
            return time1 < time2 ? -1 : (time2 > time1 ? 1 : 0);
        }
    }

    public static class Params {
        public final long mCacheSizeLimitMinimum;
        public final long mLowDiskSpaceCacheSizeLimit;
        public final long mDefaultCacheSizeLimit;

        public Params(long cacheSizeLimitMinimum, long lowDiskSpaceCacheSizeLimit, long defaultCacheSizeLimit) {
            this.mCacheSizeLimitMinimum = cacheSizeLimitMinimum;
            this.mLowDiskSpaceCacheSizeLimit = lowDiskSpaceCacheSizeLimit;
            this.mDefaultCacheSizeLimit = defaultCacheSizeLimit;
        }
    }

    @VisibleForTesting
    static class CacheStats {
        private boolean mInitialized = false;
        private long mSize = -1L;
        private long mCount = -1L;

        CacheStats() {
        }

        public synchronized boolean isInitialized() {
            return this.mInitialized;
        }

        public synchronized void reset() {
            this.mInitialized = false;
            this.mCount = -1L;
            this.mSize = -1L;
        }

        public synchronized void set(long size, long count) {
            this.mCount = count;
            this.mSize = size;
            this.mInitialized = true;
        }

        public synchronized void increment(long sizeIncrement, long countIncrement) {
            if (this.mInitialized) {
                this.mSize += sizeIncrement;
                this.mCount += countIncrement;
            }
        }

        public synchronized long getSize() {
            return this.mSize;
        }

        public synchronized long getCount() {
            return this.mCount;
        }
    }
}

