/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.factory;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.gif.GifImage;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.webp.WebPImage;

public class AnimatedImageFactory {
    private final AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;

    public AnimatedImageFactory(AnimatedDrawableBackendProvider animatedDrawableBackendProvider) {
        this.mAnimatedDrawableBackendProvider = animatedDrawableBackendProvider;
    }

    public CloseableImage decodeGif(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageDecodeOptions options) {
        Preconditions.checkState((!options.forceOldAnimationCode ? 1 : 0) != 0);
        PooledByteBuffer input = (PooledByteBuffer)pooledByteBufferRef.get();
        GifImage gifImage = GifImage.create(input.getNativePtr(), input.size());
        return this.getCloseableImage(options, gifImage);
    }

    public CloseableImage decodeWebP(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageDecodeOptions options) {
        Preconditions.checkArgument((!options.forceOldAnimationCode ? 1 : 0) != 0);
        PooledByteBuffer input = (PooledByteBuffer)pooledByteBufferRef.get();
        WebPImage webPImage = WebPImage.create(input.getNativePtr(), input.size());
        return this.getCloseableImage(options, webPImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableImage getCloseableImage(ImageDecodeOptions options, AnimatedImage image) {
        int frameForPreview = options.useLastFrameForPreview ? image.getFrameCount() - 1 : 0;
        CloseableReference<Bitmap> previewBitmap = null;
        if (options.decodePreviewFrame) {
            previewBitmap = this.createPreviewBitmap(image, frameForPreview);
        }
        try {
            AnimatedImageResult animatedImageResult = AnimatedImageResult.newBuilder(image).setPreviewBitmap(previewBitmap).setFrameForPreview(frameForPreview).build();
            CloseableAnimatedImage closeableAnimatedImage = new CloseableAnimatedImage(animatedImageResult);
            return closeableAnimatedImage;
        }
        finally {
            CloseableReference.closeSafely(previewBitmap);
        }
    }

    private CloseableReference<Bitmap> createPreviewBitmap(AnimatedImage image, int frameForPreview) {
        Bitmap previewBitmap = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        AnimatedImageResult tempResult = AnimatedImageResult.forAnimatedImage(image);
        AnimatedDrawableBackend drawableBackend = this.mAnimatedDrawableBackendProvider.get(tempResult, null);
        AnimatedImageCompositor animatedImageCompositor = new AnimatedImageCompositor(drawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return null;
            }
        });
        animatedImageCompositor.renderFrame(frameForPreview, previewBitmap);
        return CloseableReference.of((Object)previewBitmap, (ResourceReleaser)new ResourceReleaser<Bitmap>(){

            public void release(Bitmap value) {
                value.recycle();
            }
        });
    }
}

