/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Task;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.ImageCacheStatsTracker;
import com.facebook.imagepipeline.cache.StagingArea;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BufferedDiskCache {
    private static final Class<?> TAG = BufferedDiskCache.class;
    private final FileCache mFileCache;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final PooledByteStreams mPooledByteStreams;
    private final Executor mReadExecutor;
    private final Executor mWriteExecutor;
    private final StagingArea mStagingArea;
    private final ImageCacheStatsTracker mImageCacheStatsTracker;

    public BufferedDiskCache(FileCache fileCache, PooledByteBufferFactory pooledByteBufferFactory, PooledByteStreams pooledByteStreams, Executor readExecutor, Executor writeExecutor, ImageCacheStatsTracker imageCacheStatsTracker) {
        this.mFileCache = fileCache;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mPooledByteStreams = pooledByteStreams;
        this.mReadExecutor = readExecutor;
        this.mWriteExecutor = writeExecutor;
        this.mImageCacheStatsTracker = imageCacheStatsTracker;
        this.mStagingArea = StagingArea.getInstance();
    }

    public Task<CloseableReference<PooledByteBuffer>> get(final CacheKey key, final AtomicBoolean isCancelled) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)isCancelled);
        CloseableReference<PooledByteBuffer> pinnedImage = this.mStagingArea.get(key);
        if (pinnedImage != null) {
            FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.toString());
            this.mImageCacheStatsTracker.onStagingAreaHit();
            return Task.forResult(pinnedImage);
        }
        try {
            return Task.call((Callable)new Callable<CloseableReference<PooledByteBuffer>>(){

                @Override
                public CloseableReference<PooledByteBuffer> call() throws Exception {
                    if (isCancelled.get()) {
                        throw new CancellationException();
                    }
                    CloseableReference result = BufferedDiskCache.this.mStagingArea.get(key);
                    if (result != null) {
                        FLog.v((Class)TAG, (String)"Found image for %s in staging area", (Object)key.toString());
                        BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaHit();
                    } else {
                        FLog.v((Class)TAG, (String)"Did not find image for %s in staging area", (Object)key.toString());
                        BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaMiss();
                        try {
                            PooledByteBuffer buffer = BufferedDiskCache.this.readFromDiskCache(key);
                            result = CloseableReference.of((Closeable)buffer);
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    if (Thread.interrupted()) {
                        FLog.v((Class)TAG, (String)"Host thread was interrupted, decreasing reference count");
                        if (result != null) {
                            result.close();
                        }
                        throw new InterruptedException();
                    }
                    return result;
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])new Object[]{key.toString()});
            return Task.forError((Exception)exception);
        }
    }

    public void put(final CacheKey key, CloseableReference<PooledByteBuffer> byteBuffer) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)CloseableReference.isValid(byteBuffer));
        this.mStagingArea.put(key, byteBuffer);
        final CloseableReference finalByteBuffer = byteBuffer.clone();
        try {
            this.mWriteExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BufferedDiskCache.this.writeToDiskCache(key, (PooledByteBuffer)finalByteBuffer.get());
                    }
                    finally {
                        BufferedDiskCache.this.mStagingArea.remove(key, (CloseableReference<PooledByteBuffer>)finalByteBuffer);
                        finalByteBuffer.close();
                    }
                }
            });
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache write for %s", (Object[])new Object[]{key.toString()});
            this.mStagingArea.remove(key, byteBuffer);
            finalByteBuffer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledByteBuffer readFromDiskCache(CacheKey key) throws IOException {
        try {
            PooledByteBuffer byteBuffer;
            FLog.v(TAG, (String)"Disk cache read for %s", (Object)key.toString());
            BinaryResource diskCacheResource = this.mFileCache.getResource(key);
            if (diskCacheResource == null) {
                FLog.v(TAG, (String)"Disk cache miss for %s", (Object)key.toString());
                this.mImageCacheStatsTracker.onDiskCacheMiss();
                return null;
            }
            FLog.v(TAG, (String)"Found entry in disk cache for %s", (Object)key.toString());
            this.mImageCacheStatsTracker.onDiskCacheHit();
            try (InputStream is = diskCacheResource.openStream();){
                byteBuffer = this.mPooledByteBufferFactory.newByteBuffer(is, (int)diskCacheResource.size());
            }
            FLog.v(TAG, (String)"Successful read from disk cache for %s", (Object)key.toString());
            return byteBuffer;
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Exception reading from cache for %s", (Object[])new Object[]{key.toString()});
            this.mImageCacheStatsTracker.onDiskCacheGetFail();
            throw ioe;
        }
    }

    private void writeToDiskCache(CacheKey key, final PooledByteBuffer buffer) {
        FLog.v(TAG, (String)"About to write to disk-cache for key %s", (Object)key.toString());
        try {
            this.mFileCache.insert(key, new WriterCallback(){

                @Override
                public void write(OutputStream os) throws IOException {
                    BufferedDiskCache.this.mPooledByteStreams.copy(buffer.getStream(), os);
                }
            });
            FLog.v(TAG, (String)"Successful disk-cache write for key %s", (Object)key.toString());
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Failed to write to disk-cache for key %s", (Object[])new Object[]{key.toString()});
        }
    }
}

