/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.android.internal.util.Predicate;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheTracker;
import javax.annotation.Nullable;

public class InstrumentedMemoryCache<K, V, S>
implements MemoryCache<K, V, S> {
    private final MemoryCache<K, V, S> mDelegate;
    private final MemoryCacheTracker mTracker;

    public InstrumentedMemoryCache(MemoryCache<K, V, S> delegate, MemoryCacheTracker tracker) {
        this.mDelegate = delegate;
        this.mTracker = tracker;
    }

    @Override
    public CloseableReference<V> get(K key, @Nullable S lookupStrategy) {
        CloseableReference<V> result = this.mDelegate.get(key, lookupStrategy);
        if (result == null) {
            this.mTracker.onCacheMiss();
        } else {
            this.mTracker.onCacheHit();
        }
        return result;
    }

    @Override
    public CloseableReference<V> cache(K key, CloseableReference<V> value) {
        this.mTracker.onCachePut();
        return this.mDelegate.cache(key, value);
    }

    @Override
    public long removeAll(Predicate<K> match) {
        return this.mDelegate.removeAll(match);
    }
}

