/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.NoOpMemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.DefaultBitmapPoolParams;
import com.facebook.imagepipeline.memory.DefaultByteArrayPoolParams;
import com.facebook.imagepipeline.memory.DefaultNativeMemoryChunkPoolParams;
import com.facebook.imagepipeline.memory.DefaultSingleByteArrayPoolParams;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.NoOpSingleByteArrayPoolStatsTracker;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import com.facebook.imagepipeline.memory.SingleByteArrayPoolStatsTracker;

public class PoolConfig {
    private final PoolParams mBitmapPoolParams;
    private final PoolStatsTracker mBitmapPoolStatsTracker;
    private final PoolParams mCommonByteArrayPoolParams;
    private final PoolStatsTracker mCommonByteArrayPoolStatsTracker;
    private final MemoryTrimmableRegistry mMemoryTrimmableRegistry;
    private final PoolParams mNativeMemoryChunkPoolParams;
    private final PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
    private final PoolParams mSingleByteArrayPoolParams;
    private final SingleByteArrayPoolStatsTracker mSingleByteArrayPoolStatsTracker;

    private PoolConfig(Builder builder) {
        this.mBitmapPoolParams = builder.mBitmapPoolParams == null ? DefaultBitmapPoolParams.get() : builder.mBitmapPoolParams;
        this.mBitmapPoolStatsTracker = builder.mBitmapPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mBitmapPoolStatsTracker;
        this.mCommonByteArrayPoolParams = builder.mCommonByteArrayPoolParams == null ? DefaultByteArrayPoolParams.get() : builder.mCommonByteArrayPoolParams;
        this.mCommonByteArrayPoolStatsTracker = builder.mCommonByteArrayPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mCommonByteArrayPoolStatsTracker;
        this.mMemoryTrimmableRegistry = builder.mMemoryTrimmableRegistry == null ? NoOpMemoryTrimmableRegistry.getInstance() : builder.mMemoryTrimmableRegistry;
        this.mNativeMemoryChunkPoolParams = builder.mNativeMemoryChunkPoolParams == null ? DefaultNativeMemoryChunkPoolParams.get() : builder.mNativeMemoryChunkPoolParams;
        this.mNativeMemoryChunkPoolStatsTracker = builder.mNativeMemoryChunkPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mNativeMemoryChunkPoolStatsTracker;
        this.mSingleByteArrayPoolParams = builder.mSingleByteArrayPoolParams == null ? DefaultSingleByteArrayPoolParams.get() : builder.mSingleByteArrayPoolParams;
        this.mSingleByteArrayPoolStatsTracker = builder.mSingleByteArrayPoolStatsTracker == null ? NoOpSingleByteArrayPoolStatsTracker.getInstance() : builder.mSingleByteArrayPoolStatsTracker;
    }

    public PoolParams getBitmapPoolParams() {
        return this.mBitmapPoolParams;
    }

    public PoolStatsTracker getBitmapPoolStatsTracker() {
        return this.mBitmapPoolStatsTracker;
    }

    public PoolParams getCommonByteArrayPoolParams() {
        return this.mCommonByteArrayPoolParams;
    }

    public PoolStatsTracker getCommonByteArrayPoolStatsTracker() {
        return this.mCommonByteArrayPoolStatsTracker;
    }

    public MemoryTrimmableRegistry getMemoryTrimmableRegistry() {
        return this.mMemoryTrimmableRegistry;
    }

    public PoolParams getNativeMemoryChunkPoolParams() {
        return this.mNativeMemoryChunkPoolParams;
    }

    public PoolStatsTracker getNativeMemoryChunkPoolStatsTracker() {
        return this.mNativeMemoryChunkPoolStatsTracker;
    }

    public PoolParams getSingleByteArrayPoolParams() {
        return this.mSingleByteArrayPoolParams;
    }

    public SingleByteArrayPoolStatsTracker getSingleByteArrayPoolStatsTracker() {
        return this.mSingleByteArrayPoolStatsTracker;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PoolParams mBitmapPoolParams;
        private PoolStatsTracker mBitmapPoolStatsTracker;
        private PoolParams mCommonByteArrayPoolParams;
        private PoolStatsTracker mCommonByteArrayPoolStatsTracker;
        private MemoryTrimmableRegistry mMemoryTrimmableRegistry;
        private PoolParams mNativeMemoryChunkPoolParams;
        private PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
        private PoolParams mSingleByteArrayPoolParams;
        private SingleByteArrayPoolStatsTracker mSingleByteArrayPoolStatsTracker;

        private Builder() {
        }

        public Builder setBitmapPoolParams(PoolParams bitmapPoolParams) {
            this.mBitmapPoolParams = (PoolParams)Preconditions.checkNotNull((Object)bitmapPoolParams);
            return this;
        }

        public Builder setBitmapPoolStatsTracker(PoolStatsTracker bitmapPoolStatsTracker) {
            this.mBitmapPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)bitmapPoolStatsTracker);
            return this;
        }

        public Builder setCommonByteArrayPoolParams(PoolParams commonByteArrayPoolParams) {
            this.mCommonByteArrayPoolParams = (PoolParams)Preconditions.checkNotNull((Object)commonByteArrayPoolParams);
            return this;
        }

        public Builder setCommonByteArrayPoolStatsTracker(PoolStatsTracker commonByteArrayPoolStatsTracker) {
            this.mCommonByteArrayPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)commonByteArrayPoolStatsTracker);
            return this;
        }

        public Builder setMemoryTrimmableRegistry(MemoryTrimmableRegistry memoryTrimmableRegistry) {
            this.mMemoryTrimmableRegistry = memoryTrimmableRegistry;
            return this;
        }

        public Builder setNativeMemoryChunkPoolParams(PoolParams nativeMemoryChunkPoolParams) {
            this.mNativeMemoryChunkPoolParams = (PoolParams)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolParams);
            return this;
        }

        public Builder setNativeMemoryChunkPoolStatsTracker(PoolStatsTracker nativeMemoryChunkPoolStatsTracker) {
            this.mNativeMemoryChunkPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolStatsTracker);
            return this;
        }

        public Builder setSingleByteArrayPoolParams(PoolParams singleByteArrayPoolParams) {
            this.mSingleByteArrayPoolParams = singleByteArrayPoolParams;
            return this;
        }

        public Builder setSingleByteArrayPoolStatsTracker(SingleByteArrayPoolStatsTracker nativeMemoryChunkPoolStatsTracker) {
            this.mSingleByteArrayPoolStatsTracker = (SingleByteArrayPoolStatsTracker)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolStatsTracker);
            return this;
        }

        public PoolConfig build() {
            return new PoolConfig(this);
        }
    }
}

