/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.producers.MemoryCacheProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.request.ImageRequest;

public class BitmapMemoryCacheGetProducer
extends MemoryCacheProducer<BitmapMemoryCacheKey, CloseableImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "BitmapMemoryCacheGetProducer";

    public BitmapMemoryCacheGetProducer(MemoryCache<BitmapMemoryCacheKey, CloseableImage, Void> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> nextProducer) {
        super(memoryCache, cacheKeyFactory, nextProducer);
    }

    @Override
    protected BitmapMemoryCacheKey getCacheKey(ImageRequest imageRequest) {
        return this.mCacheKeyFactory.getBitmapCacheKey(imageRequest);
    }

    @Override
    protected boolean shouldStartNextProducer(CloseableReference<CloseableImage> cachedResultFound) {
        return !((CloseableImage)cachedResultFound.get()).getQualityInfo().isOfFullQuality();
    }

    @Override
    protected boolean shouldCacheReturnedValues() {
        return false;
    }

    @Override
    protected boolean shouldCacheResult(CloseableReference<CloseableImage> result, BitmapMemoryCacheKey cacheKey, boolean isLast) {
        return false;
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

