/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DiskCacheProducer
implements Producer<CloseableReference<PooledByteBuffer>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "DiskCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public DiskCacheProducer(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(final Consumer<CloseableReference<PooledByteBuffer>> consumer, final ProducerContext producerContext) {
        final ProducerListener listener = producerContext.getListener();
        final String requestId = producerContext.getId();
        listener.onProducerStart(requestId, PRODUCER_NAME);
        ImageRequest imageRequest = producerContext.getImageRequest();
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest);
        final BufferedDiskCache cache = imageRequest.getImageType() == ImageRequest.ImageType.SMALL ? this.mSmallImageBufferedDiskCache : this.mDefaultBufferedDiskCache;
        Continuation<CloseableReference<PooledByteBuffer>, Void> continuation = new Continuation<CloseableReference<PooledByteBuffer>, Void>(){

            public Void then(Task<CloseableReference<PooledByteBuffer>> task) throws Exception {
                if (task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException) {
                    listener.onProducerFinishWithCancellation(requestId, DiskCacheProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(requestId, DiskCacheProducer.PRODUCER_NAME, task.getError(), null);
                    DiskCacheProducer.this.mNextProducer.produceResults(new DiskCacheConsumer(consumer, cache, cacheKey), producerContext);
                } else {
                    CloseableReference cachedReference = (CloseableReference)task.getResult();
                    if (cachedReference != null) {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, true));
                        consumer.onNewResult(cachedReference, true);
                        cachedReference.close();
                    } else {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, false));
                        DiskCacheProducer.this.mNextProducer.produceResults(new DiskCacheConsumer(consumer, cache, cacheKey), producerContext);
                    }
                }
                return null;
            }
        };
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        Task<CloseableReference<PooledByteBuffer>> diskCacheLookupTask = cache.get(cacheKey, isCancelled);
        diskCacheLookupTask.continueWith((Continuation)continuation);
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener listener, String requestId, boolean valueFound) {
        if (!listener.requiresExtraMap(requestId)) {
            return null;
        }
        return ImmutableMap.of((Object)VALUE_FOUND, (Object)String.valueOf(valueFound));
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    private class DiskCacheConsumer
    extends BaseConsumer<CloseableReference<PooledByteBuffer>> {
        private final Consumer<CloseableReference<PooledByteBuffer>> mConsumer;
        private final BufferedDiskCache mCache;
        private final CacheKey mCacheKey;

        private DiskCacheConsumer(Consumer<CloseableReference<PooledByteBuffer>> consumer, BufferedDiskCache cache, CacheKey cacheKey) {
            this.mConsumer = consumer;
            this.mCache = cache;
            this.mCacheKey = cacheKey;
        }

        @Override
        public void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (newResult != null && isLast) {
                this.mCache.put(this.mCacheKey, newResult);
            }
            this.mConsumer.onNewResult(newResult, isLast);
        }

        @Override
        public void onFailureImpl(Throwable t) {
            this.mConsumer.onFailure(t);
        }

        @Override
        public void onCancellationImpl() {
            this.mConsumer.onCancellation();
        }
    }
}

