/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.ByteArrayPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.NetworkFetchProducer;
import com.facebook.imagepipeline.producers.NfpRequestState;
import com.facebook.imagepipeline.producers.ProducerContext;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class HttpURLConnectionNetworkFetchProducer
extends NetworkFetchProducer<NfpRequestState> {
    private static final int NUM_NETWORK_THREADS = 3;
    private final Executor mExecutor = Executors.newFixedThreadPool(3);

    public HttpURLConnectionNetworkFetchProducer(PooledByteBufferFactory pooledByteBufferFactory, ByteArrayPool byteArrayPool) {
        super(pooledByteBufferFactory, byteArrayPool);
    }

    @Override
    protected NfpRequestState newRequestState(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
        return new NfpRequestState(consumer, context);
    }

    @Override
    protected void fetchImage(final NfpRequestState requestState) {
        this.mExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection connection = null;
                try {
                    Uri uri = requestState.getUri();
                    URL url = new URL(uri.toString());
                    connection = (HttpURLConnection)url.openConnection();
                    InputStream is = connection.getInputStream();
                    HttpURLConnectionNetworkFetchProducer.this.processResult(requestState, is, 0, false);
                }
                catch (Exception e) {
                    HttpURLConnectionNetworkFetchProducer.this.onFailure(requestState, e, null);
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        });
    }
}

