/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import android.media.ExifInterface;
import android.util.Pair;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.JfifUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;

public class LocalExifThumbnailProducer
implements Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalExifThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;

    public LocalExifThumbnailProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
    }

    @Override
    public void produceResults(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> cancellableProducerRunnable = new StatefulProducerRunnable<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>>(consumer, listener, PRODUCER_NAME, requestId){

            protected Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> getResult() throws Exception {
                ExifInterface exifInterface = LocalExifThumbnailProducer.this.getExifInterface(imageRequest.getSourceFile().getPath());
                if (!exifInterface.hasThumbnail()) {
                    return null;
                }
                byte[] bytes = exifInterface.getThumbnail();
                PooledByteBuffer pooledByteBuffer = LocalExifThumbnailProducer.this.mPooledByteBufferFactory.newByteBuffer(bytes);
                ImageTransformMetaData imageTransformMetaData = LocalExifThumbnailProducer.this.getImageTransformMetaData(pooledByteBuffer, exifInterface);
                return Pair.create((Object)CloseableReference.of((Closeable)pooledByteBuffer), (Object)imageTransformMetaData);
            }

            @Override
            protected void disposeResult(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> result) {
                if (result != null) {
                    CloseableReference.closeSafely((CloseableReference)((CloseableReference)result.first));
                }
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> result) {
                return ImmutableMap.of((Object)LocalExifThumbnailProducer.CREATED_THUMBNAIL, (Object)Boolean.toString(result != null));
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    @VisibleForTesting
    ExifInterface getExifInterface(String path) throws IOException {
        return new ExifInterface(path);
    }

    private ImageTransformMetaData getImageTransformMetaData(PooledByteBuffer imageRef, ExifInterface exifInterface) {
        ImageTransformMetaData.Builder builder = ImageTransformMetaData.newBuilder().setImageFormat(ImageFormat.JPEG);
        builder.setRotationAngle(this.getRotationAngle(exifInterface));
        Rect dimensions = JfifUtil.getDimensions(imageRef.getStream());
        if (dimensions != null) {
            builder.setWidth(dimensions.width());
            builder.setHeight(dimensions.height());
        }
        return builder.build();
    }

    private int getRotationAngle(ExifInterface exifInterface) {
        return JfifUtil.getAutoRotateAngleFromOrientation(Integer.parseInt(exifInterface.getAttribute("Orientation")));
    }
}

