/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.internal.Maps;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Sets;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.MultiplexProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class MultiplexProducer<K, T>
implements Producer<CloseableReference<T>> {
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<K, Multiplexer> mMultiplexers;
    private final Producer<CloseableReference<T>> mNextProducer;

    protected MultiplexProducer(Producer nextProducer) {
        this.mNextProducer = nextProducer;
        this.mMultiplexers = Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<CloseableReference<T>> consumer, ProducerContext context) {
        boolean createdNewMultiplexer;
        Multiplexer multiplexer;
        K key = this.getKey(context);
        do {
            createdNewMultiplexer = false;
            MultiplexProducer multiplexProducer = this;
            synchronized (multiplexProducer) {
                multiplexer = this.getExistingMultiplexer(key);
                if (multiplexer == null) {
                    multiplexer = this.createAndPutNewMultiplexer(key);
                    createdNewMultiplexer = true;
                }
            }
        } while (!multiplexer.addNewConsumer(consumer, context));
        if (createdNewMultiplexer) {
            multiplexer.startNextProducerIfHasAttachedConsumers();
        }
    }

    private synchronized Multiplexer getExistingMultiplexer(K key) {
        return this.mMultiplexers.get(key);
    }

    private synchronized Multiplexer createAndPutNewMultiplexer(K key) {
        Multiplexer multiplexer = new Multiplexer(key);
        this.mMultiplexers.put(key, multiplexer);
        return multiplexer;
    }

    private synchronized void removeMultiplexer(K key, Multiplexer multiplexer) {
        if (this.mMultiplexers.get(key) == multiplexer) {
            this.mMultiplexers.remove(key);
        }
    }

    protected abstract K getKey(ProducerContext var1);

    @VisibleForTesting
    class Multiplexer {
        private final K mKey;
        private final CopyOnWriteArraySet<Pair<Consumer<CloseableReference<T>>, ProducerContext>> mConsumerContextPairs = Sets.newCopyOnWriteArraySet();
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private CloseableReference<T> mLastIntermediateResult;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private SettableProducerContext mMultiplexProducerContext;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer mForwardingConsumer;

        public Multiplexer(K key) {
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addNewConsumer(Consumer<CloseableReference<T>> consumer, ProducerContext producerContext) {
            CloseableReference lastIntermediateResult;
            Pair consumerContextPair = Pair.create(consumer, (Object)producerContext);
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (MultiplexProducer.this.getExistingMultiplexer(this.mKey) != this) {
                    return false;
                }
                this.mConsumerContextPairs.add(consumerContextPair);
                if (this.mMultiplexProducerContext != null) {
                    if (this.mMultiplexProducerContext.isPrefetch()) {
                        this.mMultiplexProducerContext.setIsPrefetch(((ProducerContext)consumerContextPair.second).isPrefetch());
                    }
                    if (!this.mMultiplexProducerContext.isIntermediateResultExpected()) {
                        this.mMultiplexProducerContext.setIsIntermediateResultExpected(((ProducerContext)consumerContextPair.second).isIntermediateResultExpected());
                    }
                    this.mMultiplexProducerContext.setPriority(Priority.getHigherPriority(this.mMultiplexProducerContext.getPriority(), ((ProducerContext)consumerContextPair.second).getPriority()));
                }
                lastIntermediateResult = this.mLastIntermediateResult;
            }
            multiplexer = consumerContextPair;
            synchronized (multiplexer) {
                Multiplexer multiplexer2 = this;
                synchronized (multiplexer2) {
                    if (lastIntermediateResult != this.mLastIntermediateResult) {
                        lastIntermediateResult = null;
                    } else if (lastIntermediateResult != null) {
                        lastIntermediateResult = lastIntermediateResult.clone();
                    }
                }
                if (lastIntermediateResult != null) {
                    consumer.onNewResult(lastIntermediateResult, false);
                    lastIntermediateResult.close();
                }
            }
            this.addCallbacks(consumerContextPair, producerContext);
            return true;
        }

        private void addCallbacks(final Pair<Consumer<CloseableReference<T>>, ProducerContext> consumerContextPair, ProducerContext producerContext) {
            producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellationRequested() {
                    SettableProducerContext contextToCancel = null;
                    boolean pairWasRemoved = false;
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        pairWasRemoved = Multiplexer.this.mConsumerContextPairs.remove(consumerContextPair);
                        if (pairWasRemoved) {
                            if (Multiplexer.this.mConsumerContextPairs.isEmpty()) {
                                contextToCancel = Multiplexer.this.mMultiplexProducerContext;
                            } else if (Multiplexer.this.mMultiplexProducerContext != null) {
                                if (!Multiplexer.this.mMultiplexProducerContext.isPrefetch() && !((ProducerContext)consumerContextPair.second).isPrefetch()) {
                                    Multiplexer.this.mMultiplexProducerContext.setIsPrefetch(Multiplexer.this.isPrefetch());
                                }
                                if (((ProducerContext)consumerContextPair.second).isIntermediateResultExpected()) {
                                    Multiplexer.this.mMultiplexProducerContext.setIsIntermediateResultExpected(Multiplexer.this.isIntermediateResultExpected());
                                }
                                if (Multiplexer.this.mMultiplexProducerContext.getPriority().equals((Object)((ProducerContext)consumerContextPair.second).getPriority())) {
                                    Multiplexer.this.mMultiplexProducerContext.setPriority(Multiplexer.this.getPriority());
                                }
                            }
                        }
                    }
                    if (contextToCancel != null) {
                        contextToCancel.cancel();
                    }
                    if (pairWasRemoved) {
                        ((Consumer)consumerContextPair.first).onCancellation();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onIsPrefetchChanged() {
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        if (Multiplexer.this.mMultiplexProducerContext != null) {
                            if (Multiplexer.this.mMultiplexProducerContext.isPrefetch()) {
                                Multiplexer.this.mMultiplexProducerContext.setIsPrefetch(((ProducerContext)consumerContextPair.second).isPrefetch());
                            } else if (((ProducerContext)consumerContextPair.second).isPrefetch()) {
                                Multiplexer.this.mMultiplexProducerContext.setIsPrefetch(Multiplexer.this.isPrefetch());
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        if (Multiplexer.this.mMultiplexProducerContext != null) {
                            if (((ProducerContext)consumerContextPair.second).isIntermediateResultExpected()) {
                                Multiplexer.this.mMultiplexProducerContext.setIsIntermediateResultExpected(true);
                            } else if (Multiplexer.this.mMultiplexProducerContext.isIntermediateResultExpected()) {
                                Multiplexer.this.mMultiplexProducerContext.setIsIntermediateResultExpected(Multiplexer.this.isIntermediateResultExpected());
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onPriorityChanged() {
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        if (Multiplexer.this.mMultiplexProducerContext != null) {
                            Priority newPriority = ((ProducerContext)consumerContextPair.second).getPriority();
                            if (Priority.getHigherPriority(Multiplexer.this.mMultiplexProducerContext.getPriority(), newPriority).equals((Object)newPriority)) {
                                Multiplexer.this.mMultiplexProducerContext.setPriority(newPriority);
                            } else {
                                Multiplexer.this.mMultiplexProducerContext.setPriority(Multiplexer.this.getPriority());
                            }
                        }
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startNextProducerIfHasAttachedConsumers() {
            com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer forwardingConsumer;
            SettableProducerContext multiplexProducerContext;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                Preconditions.checkArgument((this.mMultiplexProducerContext == null ? 1 : 0) != 0);
                Preconditions.checkArgument((this.mForwardingConsumer == null ? 1 : 0) != 0);
                if (this.mConsumerContextPairs.isEmpty()) {
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                    return;
                }
                ProducerContext producerContext = (ProducerContext)this.mConsumerContextPairs.iterator().next().second;
                this.mMultiplexProducerContext = new SettableProducerContext(producerContext.getImageRequest(), producerContext.getId(), producerContext.getListener(), producerContext.getCallerContext(), this.isPrefetch(), this.isIntermediateResultExpected(), this.getPriority());
                this.mForwardingConsumer = new ForwardingConsumer();
                multiplexProducerContext = this.mMultiplexProducerContext;
                forwardingConsumer = this.mForwardingConsumer;
            }
            MultiplexProducer.this.mNextProducer.produceResults(forwardingConsumer, multiplexProducerContext);
        }

        private synchronized boolean isPrefetch() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (((ProducerContext)pair.second).isPrefetch()) continue;
                return false;
            }
            return true;
        }

        private synchronized boolean isIntermediateResultExpected() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (!((ProducerContext)pair.second).isIntermediateResultExpected()) continue;
                return true;
            }
            return false;
        }

        private synchronized Priority getPriority() {
            Priority priority = Priority.LOW;
            for (Pair pair : this.mConsumerContextPairs) {
                priority = Priority.getHigherPriority(priority, ((ProducerContext)pair.second).getPriority());
            }
            return priority;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(ForwardingConsumer consumer, Throwable t) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                iterator = this.mConsumerContextPairs.iterator();
                this.mConsumerContextPairs.clear();
                MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onFailure(t);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNextResult(ForwardingConsumer consumer, CloseableReference closeableReference, boolean isFinal) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
                iterator = this.mConsumerContextPairs.iterator();
                if (!isFinal) {
                    this.mLastIntermediateResult = closeableReference.clone();
                } else {
                    this.mConsumerContextPairs.clear();
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                }
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onNewResult(closeableReference, isFinal);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancelled(ForwardingConsumer forwardingConsumer) {
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != forwardingConsumer) {
                    return;
                }
                this.mForwardingConsumer = null;
                this.mMultiplexProducerContext = null;
                CloseableReference.closeSafely(this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            this.startNextProducerIfHasAttachedConsumers();
        }

        private class ForwardingConsumer
        extends BaseConsumer<CloseableReference<T>> {
            private ForwardingConsumer() {
            }

            @Override
            protected void onNewResultImpl(CloseableReference<T> newResult, boolean isLast) {
                Multiplexer.this.onNextResult(this, newResult, isLast);
            }

            @Override
            protected void onFailureImpl(Throwable t) {
                Multiplexer.this.onFailure(this, t);
            }

            @Override
            protected void onCancellationImpl() {
                Multiplexer.this.onCancelled(this);
            }
        }
    }
}

