/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.util.HashCodeUtil;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BitmapMemoryCacheKey
implements CacheKey {
    private final String mSourceString;
    @Nullable
    private final ResizeOptions mResizeOptions;
    private final boolean mAutoRotated;
    private final ImageDecodeOptions mImageDecodeOptions;
    @Nullable
    private final CacheKey mPostprocessorCacheKey;
    @Nullable
    private final String mPostprocessorName;
    private final int mHash;

    public BitmapMemoryCacheKey(String sourceString, @Nullable ResizeOptions resizeOptions, boolean autoRotated, ImageDecodeOptions imageDecodeOptions, @Nullable CacheKey postprocessorCacheKey, @Nullable String postprocessorName) {
        this.mSourceString = (String)Preconditions.checkNotNull((Object)sourceString);
        this.mResizeOptions = resizeOptions;
        this.mAutoRotated = autoRotated;
        this.mImageDecodeOptions = imageDecodeOptions;
        this.mPostprocessorCacheKey = postprocessorCacheKey;
        this.mPostprocessorName = postprocessorName;
        this.mHash = HashCodeUtil.hashCode((Object)sourceString.hashCode(), (Object)(resizeOptions != null ? resizeOptions.hashCode() : 0), (Object)(autoRotated ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()), (Object)this.mImageDecodeOptions, (Object)this.mPostprocessorCacheKey, (Object)postprocessorName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitmapMemoryCacheKey)) {
            return false;
        }
        BitmapMemoryCacheKey otherKey = (BitmapMemoryCacheKey)o;
        return this.mHash == otherKey.mHash && this.mSourceString.equals(otherKey.mSourceString) && Objects.equal((Object)this.mResizeOptions, (Object)otherKey.mResizeOptions) && this.mAutoRotated == otherKey.mAutoRotated && Objects.equal((Object)this.mImageDecodeOptions, (Object)otherKey.mImageDecodeOptions) && Objects.equal((Object)this.mPostprocessorCacheKey, (Object)otherKey.mPostprocessorCacheKey) && Objects.equal((Object)this.mPostprocessorName, (Object)otherKey.mPostprocessorName);
    }

    public int hashCode() {
        return this.mHash;
    }

    public boolean containsUri(Uri uri) {
        return this.getSourceUriString().contains(uri.toString());
    }

    public String getSourceUriString() {
        return this.mSourceString;
    }

    @Nullable
    public String getPostprocessorName() {
        return this.mPostprocessorName;
    }

    public String toString() {
        return String.format((Locale)null, "%s_%s_%s_%s_%s_%s_%d", this.mSourceString, this.mResizeOptions, Boolean.toString(this.mAutoRotated), this.mImageDecodeOptions, this.mPostprocessorCacheKey, this.mPostprocessorName, this.mHash);
    }
}

