/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import bolts.Task;
import com.facebook.binaryresource.BinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.WriterCallback;
import com.facebook.cache.disk.FileCache;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.ImageCacheStatsTracker;
import com.facebook.imagepipeline.cache.StagingArea;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class BufferedDiskCache {
    private static final Class<?> TAG = BufferedDiskCache.class;
    private final FileCache mFileCache;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final PooledByteStreams mPooledByteStreams;
    private final Executor mReadExecutor;
    private final Executor mWriteExecutor;
    private final StagingArea mStagingArea;
    private final ImageCacheStatsTracker mImageCacheStatsTracker;

    public BufferedDiskCache(FileCache fileCache, PooledByteBufferFactory pooledByteBufferFactory, PooledByteStreams pooledByteStreams, Executor readExecutor, Executor writeExecutor, ImageCacheStatsTracker imageCacheStatsTracker) {
        this.mFileCache = fileCache;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mPooledByteStreams = pooledByteStreams;
        this.mReadExecutor = readExecutor;
        this.mWriteExecutor = writeExecutor;
        this.mImageCacheStatsTracker = imageCacheStatsTracker;
        this.mStagingArea = StagingArea.getInstance();
    }

    public boolean containsSync(CacheKey key) {
        return this.mStagingArea.containsKey(key) || this.mFileCache.hasKeySync(key);
    }

    public Task<Boolean> contains(CacheKey key) {
        if (this.containsSync(key)) {
            return Task.forResult((Object)true);
        }
        return this.containsAsync(key);
    }

    private Task<Boolean> containsAsync(final CacheKey key) {
        try {
            return Task.call((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    EncodedImage result = BufferedDiskCache.this.mStagingArea.get(key);
                    if (result != null) {
                        result.close();
                        FLog.v((Class)TAG, (String)"Found image for %s in staging area", (Object)key.toString());
                        BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaHit();
                        return true;
                    }
                    FLog.v((Class)TAG, (String)"Did not find image for %s in staging area", (Object)key.toString());
                    BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaMiss();
                    try {
                        return BufferedDiskCache.this.mFileCache.hasKey(key);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])new Object[]{key.toString()});
            return Task.forError((Exception)exception);
        }
    }

    public Task<EncodedImage> get(CacheKey key, AtomicBoolean isCancelled) {
        EncodedImage pinnedImage = this.mStagingArea.get(key);
        if (pinnedImage != null) {
            return this.foundPinnedImage(key, pinnedImage);
        }
        return this.getAsync(key, isCancelled);
    }

    private Task<EncodedImage> getAsync(final CacheKey key, final AtomicBoolean isCancelled) {
        try {
            return Task.call((Callable)new Callable<EncodedImage>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public EncodedImage call() throws Exception {
                    if (isCancelled.get()) {
                        throw new CancellationException();
                    }
                    EncodedImage result = BufferedDiskCache.this.mStagingArea.get(key);
                    if (result != null) {
                        FLog.v((Class)TAG, (String)"Found image for %s in staging area", (Object)key.toString());
                        BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaHit();
                    } else {
                        FLog.v((Class)TAG, (String)"Did not find image for %s in staging area", (Object)key.toString());
                        BufferedDiskCache.this.mImageCacheStatsTracker.onStagingAreaMiss();
                        try {
                            PooledByteBuffer buffer = BufferedDiskCache.this.readFromDiskCache(key);
                            CloseableReference ref = CloseableReference.of((Closeable)buffer);
                            try {
                                result = new EncodedImage(ref);
                            }
                            finally {
                                CloseableReference.closeSafely((CloseableReference)ref);
                            }
                        }
                        catch (Exception exception) {
                            return null;
                        }
                    }
                    if (Thread.interrupted()) {
                        FLog.v((Class)TAG, (String)"Host thread was interrupted, decreasing reference count");
                        if (result != null) {
                            result.close();
                        }
                        throw new InterruptedException();
                    }
                    return result;
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache read for %s", (Object[])new Object[]{key.toString()});
            return Task.forError((Exception)exception);
        }
    }

    public void put(final CacheKey key, EncodedImage encodedImage) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)EncodedImage.isValid((EncodedImage)encodedImage));
        this.mStagingArea.put(key, encodedImage);
        final EncodedImage finalEncodedImage = EncodedImage.cloneOrNull((EncodedImage)encodedImage);
        try {
            this.mWriteExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedDiskCache.this.writeToDiskCache(key, finalEncodedImage);
                    }
                    finally {
                        BufferedDiskCache.this.mStagingArea.remove(key, finalEncodedImage);
                        EncodedImage.closeSafely((EncodedImage)finalEncodedImage);
                    }
                }
            });
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache write for %s", (Object[])new Object[]{key.toString()});
            this.mStagingArea.remove(key, encodedImage);
            EncodedImage.closeSafely((EncodedImage)finalEncodedImage);
        }
    }

    public Task<Void> remove(final CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        this.mStagingArea.remove(key);
        try {
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BufferedDiskCache.this.mStagingArea.remove(key);
                    BufferedDiskCache.this.mFileCache.remove(key);
                    return null;
                }
            }, (Executor)this.mWriteExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache remove for %s", (Object[])new Object[]{key.toString()});
            return Task.forError((Exception)exception);
        }
    }

    public Task<Void> clearAll() {
        this.mStagingArea.clearAll();
        try {
            return Task.call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BufferedDiskCache.this.mStagingArea.clearAll();
                    BufferedDiskCache.this.mFileCache.clearAll();
                    return null;
                }
            }, (Executor)this.mWriteExecutor);
        }
        catch (Exception exception) {
            FLog.w(TAG, (Throwable)exception, (String)"Failed to schedule disk-cache clear", (Object[])new Object[0]);
            return Task.forError((Exception)exception);
        }
    }

    private Task<EncodedImage> foundPinnedImage(CacheKey key, EncodedImage pinnedImage) {
        FLog.v(TAG, (String)"Found image for %s in staging area", (Object)key.toString());
        this.mImageCacheStatsTracker.onStagingAreaHit();
        return Task.forResult((Object)pinnedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledByteBuffer readFromDiskCache(CacheKey key) throws IOException {
        try {
            PooledByteBuffer byteBuffer;
            FLog.v(TAG, (String)"Disk cache read for %s", (Object)key.toString());
            BinaryResource diskCacheResource = this.mFileCache.getResource(key);
            if (diskCacheResource == null) {
                FLog.v(TAG, (String)"Disk cache miss for %s", (Object)key.toString());
                this.mImageCacheStatsTracker.onDiskCacheMiss();
                return null;
            }
            FLog.v(TAG, (String)"Found entry in disk cache for %s", (Object)key.toString());
            this.mImageCacheStatsTracker.onDiskCacheHit();
            try (InputStream is = diskCacheResource.openStream();){
                byteBuffer = this.mPooledByteBufferFactory.newByteBuffer(is, (int)diskCacheResource.size());
            }
            FLog.v(TAG, (String)"Successful read from disk cache for %s", (Object)key.toString());
            return byteBuffer;
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Exception reading from cache for %s", (Object[])new Object[]{key.toString()});
            this.mImageCacheStatsTracker.onDiskCacheGetFail();
            throw ioe;
        }
    }

    private void writeToDiskCache(CacheKey key, final EncodedImage encodedImage) {
        FLog.v(TAG, (String)"About to write to disk-cache for key %s", (Object)key.toString());
        try {
            this.mFileCache.insert(key, new WriterCallback(){

                public void write(OutputStream os) throws IOException {
                    BufferedDiskCache.this.mPooledByteStreams.copy(encodedImage.getInputStream(), os);
                }
            });
            FLog.v(TAG, (String)"Successful disk-cache write for key %s", (Object)key.toString());
        }
        catch (IOException ioe) {
            FLog.w(TAG, (Throwable)ioe, (String)"Failed to write to disk-cache for key %s", (Object[])new Object[]{key.toString()});
        }
    }
}

