/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.imagepipeline.request.RepeatedPostprocessor;

public class PostprocessedBitmapMemoryCacheProducer
implements Producer<CloseableReference<CloseableImage>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "PostprocessedBitmapMemoryCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<CloseableImage>> mInputProducer;

    public PostprocessedBitmapMemoryCacheProducer(MemoryCache<CacheKey, CloseableImage> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> inputProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        ImageRequest imageRequest = producerContext.getImageRequest();
        Postprocessor postprocessor = imageRequest.getPostprocessor();
        if (postprocessor == null || postprocessor.getPostprocessorCacheKey() == null) {
            this.mInputProducer.produceResults(consumer, producerContext);
            return;
        }
        listener.onProducerStart(requestId, this.getProducerName());
        CacheKey cacheKey = this.mCacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest);
        CloseableReference cachedReference = this.mMemoryCache.get((Object)cacheKey);
        if (cachedReference != null) {
            listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"true") : null);
            consumer.onProgressUpdate(1.0f);
            consumer.onNewResult((CloseableReference<CloseableImage>)cachedReference, true);
            cachedReference.close();
        } else {
            boolean isRepeatedProcessor = postprocessor instanceof RepeatedPostprocessor;
            CachedPostprocessorConsumer cachedConsumer = new CachedPostprocessorConsumer(consumer, cacheKey, isRepeatedProcessor, this.mMemoryCache);
            listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"false") : null);
            this.mInputProducer.produceResults(cachedConsumer, producerContext);
        }
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    public static class CachedPostprocessorConsumer
    extends DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>> {
        private final CacheKey mCacheKey;
        private final boolean mIsRepeatedProcessor;
        private final MemoryCache<CacheKey, CloseableImage> mMemoryCache;

        public CachedPostprocessorConsumer(Consumer<CloseableReference<CloseableImage>> consumer, CacheKey cacheKey, boolean isRepeatedProcessor, MemoryCache<CacheKey, CloseableImage> memoryCache) {
            super(consumer);
            this.mCacheKey = cacheKey;
            this.mIsRepeatedProcessor = isRepeatedProcessor;
            this.mMemoryCache = memoryCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, true);
                }
                return;
            }
            if (!isLast && !this.mIsRepeatedProcessor) {
                return;
            }
            CloseableReference<CloseableImage> newCachedResult = this.mMemoryCache.cache((Object)this.mCacheKey, newResult);
            try {
                this.getConsumer().onProgressUpdate(1.0f);
                this.getConsumer().onNewResult(newCachedResult != null ? newCachedResult : newResult, isLast);
            }
            catch (Throwable throwable) {
                CloseableReference.closeSafely((CloseableReference)newCachedResult);
                throw throwable;
            }
            CloseableReference.closeSafely(newCachedResult);
        }
    }
}

