/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imagepipeline.core.ImagePipelineConfig;

public class ImagePipelineExperiments {
    private final int mForceSmallCacheThresholdBytes;
    private final boolean mWebpSupportEnabled;
    private boolean mDecodeFileDescriptorEnabled;

    private ImagePipelineExperiments(Builder builder, ImagePipelineConfig.Builder configBuilder) {
        this.mForceSmallCacheThresholdBytes = builder.mForceSmallCacheThresholdBytes;
        this.mWebpSupportEnabled = builder.mWebpSupportEnabled && WebpSupportStatus.sWebpLibraryPresent;
        this.mDecodeFileDescriptorEnabled = configBuilder.isDownsampleEnabled() && builder.mDecodeFileDescriptorEnabled;
    }

    public boolean isDecodeFileDescriptorEnabled() {
        return this.mDecodeFileDescriptorEnabled;
    }

    public int getForceSmallCacheThresholdBytes() {
        return this.mForceSmallCacheThresholdBytes;
    }

    public boolean isWebpSupportEnabled() {
        return this.mWebpSupportEnabled;
    }

    public static Builder newBuilder(ImagePipelineConfig.Builder configBuilder) {
        return new Builder(configBuilder);
    }

    public static class Builder {
        private final ImagePipelineConfig.Builder mConfigBuilder;
        private int mForceSmallCacheThresholdBytes = 0;
        private boolean mWebpSupportEnabled = false;
        private boolean mDecodeFileDescriptorEnabled = false;

        public Builder(ImagePipelineConfig.Builder configBuilder) {
            this.mConfigBuilder = configBuilder;
        }

        public ImagePipelineConfig.Builder setDecodeFileDescriptorEnabled(boolean decodeFileDescriptorEnabled) {
            this.mDecodeFileDescriptorEnabled = decodeFileDescriptorEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setForceSmallCacheThresholdBytes(int forceSmallCacheThresholdBytes) {
            this.mForceSmallCacheThresholdBytes = forceSmallCacheThresholdBytes;
            return this.mConfigBuilder;
        }

        public ImagePipelineConfig.Builder setWebpSupportEnabled(boolean webpSupportEnabled) {
            this.mWebpSupportEnabled = webpSupportEnabled;
            return this.mConfigBuilder;
        }

        public ImagePipelineExperiments build() {
            return new ImagePipelineExperiments(this, this.mConfigBuilder);
        }
    }
}

