/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DiskCacheProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "DiskCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<EncodedImage> mInputProducer;
    private final boolean mChooseCacheByImageSize;
    private final int mForceSmallCacheThresholdBytes;

    public DiskCacheProducer(BufferedDiskCache defaultBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, Producer<EncodedImage> inputProducer, int forceSmallCacheThresholdBytes) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mInputProducer = inputProducer;
        this.mForceSmallCacheThresholdBytes = forceSmallCacheThresholdBytes;
        this.mChooseCacheByImageSize = forceSmallCacheThresholdBytes > 0;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        Task diskLookupTask;
        ImageRequest imageRequest = producerContext.getImageRequest();
        if (!imageRequest.isDiskCacheEnabled()) {
            this.maybeStartInputProducer(consumer, consumer, producerContext);
            return;
        }
        producerContext.getListener().onProducerStart(producerContext.getId(), PRODUCER_NAME);
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, producerContext.getCallerContext());
        boolean isSmallRequest = imageRequest.getImageType() == ImageRequest.ImageType.SMALL;
        BufferedDiskCache preferredCache = isSmallRequest ? this.mSmallImageBufferedDiskCache : this.mDefaultBufferedDiskCache;
        final AtomicBoolean isCancelled = new AtomicBoolean(false);
        if (this.mChooseCacheByImageSize) {
            BufferedDiskCache secondCache;
            BufferedDiskCache firstCache;
            boolean alreadyInSmall = this.mSmallImageBufferedDiskCache.containsSync(cacheKey);
            boolean alreadyInMain = this.mDefaultBufferedDiskCache.containsSync(cacheKey);
            if (alreadyInSmall || !alreadyInMain) {
                firstCache = this.mSmallImageBufferedDiskCache;
                secondCache = this.mDefaultBufferedDiskCache;
            } else {
                firstCache = this.mDefaultBufferedDiskCache;
                secondCache = this.mSmallImageBufferedDiskCache;
            }
            diskLookupTask = firstCache.get(cacheKey, isCancelled);
            diskLookupTask = diskLookupTask.continueWithTask((Continuation)new Continuation<EncodedImage, Task<EncodedImage>>(){

                public Task<EncodedImage> then(Task<EncodedImage> task) throws Exception {
                    if (DiskCacheProducer.isTaskCancelled(task) || !task.isFaulted() && task.getResult() != null) {
                        return task;
                    }
                    return secondCache.get(cacheKey, isCancelled);
                }
            });
        } else {
            diskLookupTask = preferredCache.get(cacheKey, isCancelled);
        }
        Continuation<EncodedImage, Void> continuation = this.onFinishDiskReads(consumer, preferredCache, cacheKey, producerContext);
        diskLookupTask.continueWith(continuation);
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    private Continuation<EncodedImage, Void> onFinishDiskReads(final Consumer<EncodedImage> consumer, final BufferedDiskCache preferredCache, final CacheKey preferredCacheKey, final ProducerContext producerContext) {
        final String requestId = producerContext.getId();
        final ProducerListener listener = producerContext.getListener();
        return new Continuation<EncodedImage, Void>(){

            public Void then(Task<EncodedImage> task) throws Exception {
                if (DiskCacheProducer.isTaskCancelled(task)) {
                    listener.onProducerFinishWithCancellation(requestId, DiskCacheProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(requestId, DiskCacheProducer.PRODUCER_NAME, task.getError(), null);
                    DiskCacheProducer.this.maybeStartInputProducer(consumer, new DiskCacheConsumer(consumer, preferredCache, preferredCacheKey), producerContext);
                } else {
                    EncodedImage cachedReference = (EncodedImage)task.getResult();
                    if (cachedReference != null) {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, true));
                        consumer.onProgressUpdate(1.0f);
                        consumer.onNewResult(cachedReference, true);
                        cachedReference.close();
                    } else {
                        listener.onProducerFinishWithSuccess(requestId, DiskCacheProducer.PRODUCER_NAME, DiskCacheProducer.getExtraMap(listener, requestId, false));
                        DiskCacheProducer.this.maybeStartInputProducer(consumer, new DiskCacheConsumer(consumer, preferredCache, preferredCacheKey), producerContext);
                    }
                }
                return null;
            }
        };
    }

    private static boolean isTaskCancelled(Task<?> task) {
        return task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException;
    }

    private void maybeStartInputProducer(Consumer<EncodedImage> consumerOfDiskCacheProducer, Consumer<EncodedImage> consumerOfInputProducer, ProducerContext producerContext) {
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.DISK_CACHE.getValue()) {
            consumerOfDiskCacheProducer.onNewResult(null, true);
            return;
        }
        this.mInputProducer.produceResults(consumerOfInputProducer, producerContext);
    }

    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener listener, String requestId, boolean valueFound) {
        if (!listener.requiresExtraMap(requestId)) {
            return null;
        }
        return ImmutableMap.of((Object)VALUE_FOUND, (Object)String.valueOf(valueFound));
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    private class DiskCacheConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final BufferedDiskCache mCache;
        private final CacheKey mCacheKey;

        private DiskCacheConsumer(Consumer<EncodedImage> consumer, BufferedDiskCache cache, CacheKey cacheKey) {
            super(consumer);
            this.mCache = cache;
            this.mCacheKey = cacheKey;
        }

        @Override
        public void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (newResult != null && isLast) {
                if (DiskCacheProducer.this.mChooseCacheByImageSize) {
                    int size = newResult.getSize();
                    if (size > 0 && size < DiskCacheProducer.this.mForceSmallCacheThresholdBytes) {
                        DiskCacheProducer.this.mSmallImageBufferedDiskCache.put(this.mCacheKey, newResult);
                    } else {
                        DiskCacheProducer.this.mDefaultBufferedDiskCache.put(this.mCacheKey, newResult);
                    }
                } else {
                    this.mCache.put(this.mCacheKey, newResult);
                }
            }
            this.getConsumer().onNewResult(newResult, isLast);
        }
    }
}

