/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import com.facebook.imagepipeline.request.Postprocessor;
import javax.annotation.Nullable;

public abstract class BasePostprocessor
implements Postprocessor {
    @Override
    public String getName() {
        return "Unknown postprocessor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
        CloseableReference destBitmapRef = bitmapFactory.createBitmapInternal(sourceBitmap.getWidth(), sourceBitmap.getHeight(), sourceBitmap.getConfig());
        try {
            this.process((Bitmap)destBitmapRef.get(), sourceBitmap);
            CloseableReference closeableReference = CloseableReference.cloneOrNull((CloseableReference)destBitmapRef);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)destBitmapRef);
        }
    }

    public void process(Bitmap destBitmap, Bitmap sourceBitmap) {
        Bitmaps.copyBitmap(destBitmap, sourceBitmap);
        this.process(destBitmap);
    }

    public void process(Bitmap bitmap) {
    }

    @Override
    @Nullable
    public CacheKey getPostprocessorCacheKey() {
        return null;
    }
}

