/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.os.SystemClock;
import com.android.internal.util.Predicate;
import com.facebook.common.internal.Lists;
import com.facebook.common.internal.Maps;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Sets;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.common.memory.MemoryTrimmable;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.MemoryCacheIndex;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CountingMemoryCache<K, V, S>
implements MemoryTrimmable {
    private static final Class<?> TAG = CountingMemoryCache.class;
    @VisibleForTesting
    static final long PARAMS_INTERCHECK_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);
    @GuardedBy(value="this")
    private final MemoryCacheIndex<K, V, S> mMemoryCacheIndex;
    @GuardedBy(value="this")
    @VisibleForTesting
    final LinkedHashSet<CacheEntry<K, V>> mEvictionQueue;
    @GuardedBy(value="this")
    private int mEvictionQueueSize;
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<CacheEntry<K, V>, AtomicInteger> mCachedEntries;
    @GuardedBy(value="this")
    private int mCachedValuesSize;
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<CacheEntry<K, V>, AtomicInteger> mOrphans;
    private final ValueInfoCallback<V> mValueInfoCallback;
    private final CacheTrimStrategy mCacheTrimStrategy;
    @GuardedBy(value="this")
    protected MemoryCacheParams mMemoryCacheParams;
    @GuardedBy(value="this")
    private long mLastCacheParamsCheck;
    private final Supplier<MemoryCacheParams> mMemoryCacheParamsSupplier;

    public CountingMemoryCache(MemoryCacheIndex<K, V, S> memoryCacheIndex, ValueInfoCallback<V> valueInfoCallback, CacheTrimStrategy cacheTrimStrategy, Supplier<MemoryCacheParams> memoryCacheParamsSupplier) {
        this.mMemoryCacheIndex = memoryCacheIndex;
        this.mEvictionQueue = Sets.newLinkedHashSet();
        this.mCachedEntries = Maps.newHashMap();
        this.mOrphans = Maps.newHashMap();
        this.mValueInfoCallback = valueInfoCallback;
        this.mCacheTrimStrategy = cacheTrimStrategy;
        this.mMemoryCacheParamsSupplier = memoryCacheParamsSupplier;
        this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
        this.mLastCacheParamsCheck = SystemClock.elapsedRealtime();
    }

    @VisibleForTesting
    synchronized EntryState getEntryState(CacheEntry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        if (this.mCachedEntries.containsKey(entry)) {
            if (this.mEvictionQueue.contains(entry)) {
                Preconditions.checkState((this.mCachedEntries.get(entry).get() == 0 ? 1 : 0) != 0);
                return EntryState.EXCLUSIVELY_OWNED;
            }
            Preconditions.checkState((this.mCachedEntries.get(entry).get() > 0 ? 1 : 0) != 0);
            return EntryState.SHARED;
        }
        Preconditions.checkState((!this.mEvictionQueue.contains(entry) ? 1 : 0) != 0);
        if (this.mOrphans.containsKey(entry)) {
            Preconditions.checkState((this.mOrphans.get(entry).get() > 0 ? 1 : 0) != 0);
            return EntryState.ORPHAN;
        }
        return EntryState.NOT_CACHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableReference<V> cache(K key, CloseableReference<V> value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.maybeUpdateCacheParams();
        CloseableReference removedValue = null;
        CacheEntry newCacheEntry = null;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            if (!this.canCacheNewValue(value)) {
                return null;
            }
            newCacheEntry = CacheEntry.of(key, value.clone());
            removedValue = this.handleIndexRegistration(key, newCacheEntry.value);
            this.putInCachedEntries(newCacheEntry);
            this.increaseUsageCount(newCacheEntry);
        }
        if (removedValue != null) {
            removedValue.close();
        }
        this.maybeEvictEntries();
        return newCacheEntry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableReference<V> get(K key, @Nullable S strategy) {
        CloseableReference<V> cachedValue;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            cachedValue = this.mMemoryCacheIndex.lookupValue(key, strategy);
            if (cachedValue != null) {
                CacheEntry<K, V> cacheEntry = CacheEntry.of(key, cachedValue);
                EntryState entryState = this.getEntryState(cacheEntry);
                switch (entryState) {
                    case SHARED: {
                        this.increaseUsageCount(cacheEntry);
                        break;
                    }
                    case EXCLUSIVELY_OWNED: {
                        this.removeFromEvictionQueue(cacheEntry);
                        this.increaseUsageCount(cacheEntry);
                        break;
                    }
                    default: {
                        Preconditions.checkState((boolean)false, (String)"MemoryCacheIndex returned value in invalid state: %s", (Object[])new Object[]{entryState});
                    }
                }
            }
        }
        this.maybeUpdateCacheParams();
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(K key, CloseableReference<V> value) {
        boolean shouldCloseReference = false;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            CacheEntry<K, V> cacheEntry = CacheEntry.of(key, value);
            EntryState entryState = this.getEntryState(cacheEntry);
            switch (entryState) {
                case SHARED: {
                    this.decreaseUsageCount(cacheEntry);
                    this.maybeAddToEvictionQueue(cacheEntry);
                    break;
                }
                case ORPHAN: {
                    shouldCloseReference = this.decreaseOrphansUsageCountAndMaybeRemove(cacheEntry);
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (String)"Released value is not in valid state: %s", (Object[])new Object[]{entryState});
                }
            }
        }
        if (shouldCloseReference) {
            value.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Collection<CloseableReference<V>> evictedEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            evictedEntries = this.trimEvictionQueueTo(0, 0L);
            for (CacheEntry cacheEntry : Lists.newArrayList(this.mCachedEntries.keySet())) {
                this.moveFromCachedEntriesToOrphans(cacheEntry);
                this.mMemoryCacheIndex.removeEntry(cacheEntry.key, cacheEntry.value);
            }
        }
        for (CloseableReference<V> reference : evictedEntries) {
            reference.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeAll(Predicate<K> match) {
        List<CacheEntry<K, V>> matchingEntriesFromEvictionQueue;
        long numEvictedEntries = 0L;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            matchingEntriesFromEvictionQueue = this.getMatchingEntriesFromEvictionQueue(match);
            numEvictedEntries += (long)matchingEntriesFromEvictionQueue.size();
            for (CacheEntry<K, V> cacheEntry : matchingEntriesFromEvictionQueue) {
                this.removeFromEvictionQueue(cacheEntry);
                this.removeFromCachedEntries(cacheEntry);
                this.mMemoryCacheIndex.removeEntry(cacheEntry.key, cacheEntry.value);
            }
            List<CacheEntry<K, V>> matchingCachedEntries = this.getMatchingCachedEntries(match);
            numEvictedEntries += (long)matchingCachedEntries.size();
            for (CacheEntry<K, V> cacheEntry : matchingCachedEntries) {
                this.moveFromCachedEntriesToOrphans(cacheEntry);
                this.mMemoryCacheIndex.removeEntry(cacheEntry.key, cacheEntry.value);
            }
        }
        for (CacheEntry<K, V> cacheEntry : matchingEntriesFromEvictionQueue) {
            cacheEntry.value.close();
        }
        return numEvictedEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CacheEntry<K, V>> getMatchingEntriesFromEvictionQueue(Predicate<K> match) {
        ArrayList matchingEntries = Lists.newArrayList();
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            for (CacheEntry cacheEntry : this.mEvictionQueue) {
                if (!match.apply(cacheEntry.key)) continue;
                matchingEntries.add(cacheEntry);
            }
        }
        return matchingEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CacheEntry<K, V>> getMatchingCachedEntries(Predicate<K> match) {
        ArrayList matchingEntries = Lists.newArrayList();
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            for (CacheEntry<K, V> cacheEntry : this.mCachedEntries.keySet()) {
                if (!match.apply(cacheEntry.key)) continue;
                matchingEntries.add(cacheEntry);
            }
        }
        return matchingEntries;
    }

    public void clearEvictionQueue() {
        Collection<CloseableReference<V>> evictedEntries = this.trimEvictionQueueTo(0, 0L);
        for (CloseableReference<V> reference : evictedEntries) {
            reference.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimCacheTo(int maxCount, int maxSize) {
        Collection<CloseableReference<V>> evictedEntries;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int maxLruCount = Math.max(maxCount - (this.mCachedEntries.size() - this.mEvictionQueue.size()), 0);
            int maxLruSize = Math.max(maxSize - (this.mCachedValuesSize - this.mEvictionQueueSize), 0);
            evictedEntries = this.trimEvictionQueueTo(maxLruCount, maxLruSize);
        }
        for (CloseableReference<V> reference : evictedEntries) {
            reference.close();
        }
    }

    public void trim(MemoryTrimType trimType) {
        FLog.v(TAG, (String)"Trimming cache, trim type %s", (Object)String.valueOf(trimType));
        this.mCacheTrimStrategy.trimCache(this, trimType);
    }

    public synchronized int getCount() {
        return this.mCachedEntries.size();
    }

    public synchronized int getSizeInBytes() {
        return this.mCachedValuesSize;
    }

    public synchronized int getEvictionQueueCount() {
        return this.mEvictionQueue.size();
    }

    public synchronized int getEvictionQueueSizeInBytes() {
        return this.mEvictionQueueSize;
    }

    private synchronized boolean canCacheNewValue(CloseableReference<V> value) {
        Preconditions.checkState((this.mCachedValuesSize >= this.mEvictionQueueSize ? 1 : 0) != 0);
        Preconditions.checkState((this.mCachedEntries.size() >= this.mEvictionQueue.size() ? 1 : 0) != 0);
        long newValueSize = this.mValueInfoCallback.getSizeInBytes(value.get());
        long sharedEntries = this.mCachedEntries.size() - this.mEvictionQueue.size();
        long sharedEntriesByteSize = this.mCachedValuesSize - this.mEvictionQueueSize;
        return newValueSize <= (long)this.mMemoryCacheParams.maxCacheEntrySize && sharedEntries < (long)this.mMemoryCacheParams.maxCacheEntries && sharedEntriesByteSize + newValueSize <= (long)this.mMemoryCacheParams.maxCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void maybeUpdateCacheParams() {
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            if (this.mLastCacheParamsCheck + PARAMS_INTERCHECK_INTERVAL_MS > SystemClock.elapsedRealtime()) {
                return;
            }
            this.mLastCacheParamsCheck = SystemClock.elapsedRealtime();
            this.mMemoryCacheParams = (MemoryCacheParams)this.mMemoryCacheParamsSupplier.get();
        }
        this.maybeEvictEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void maybeEvictEntries() {
        Collection<CloseableReference<V>> evictedValues;
        CountingMemoryCache countingMemoryCache = this;
        synchronized (countingMemoryCache) {
            int allowedEvictionQueueCount = CountingMemoryCache.newEvictionQueueLimit(this.mCachedEntries.size(), this.mMemoryCacheParams.maxCacheEntries, this.mEvictionQueue.size(), this.mMemoryCacheParams.maxEvictionQueueEntries);
            long allowedEvictionQueueBytes = CountingMemoryCache.newEvictionQueueLimit(this.mCachedValuesSize, this.mMemoryCacheParams.maxCacheSize, this.mEvictionQueueSize, this.mMemoryCacheParams.maxEvictionQueueSize);
            evictedValues = this.trimEvictionQueueTo(allowedEvictionQueueCount, allowedEvictionQueueBytes);
        }
        for (CloseableReference<V> evictedValue : evictedValues) {
            evictedValue.close();
        }
    }

    private synchronized Collection<CloseableReference<V>> trimEvictionQueueTo(int count, long size) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        ArrayList evictedValues = Lists.newArrayList();
        while (this.mEvictionQueue.size() > count || (long)this.mEvictionQueueSize > size) {
            CacheEntry cacheEntry = (CacheEntry)this.mEvictionQueue.iterator().next();
            evictedValues.add(cacheEntry.value);
            this.removeFromEvictionQueue(cacheEntry);
            this.removeFromCachedEntries(cacheEntry);
            this.mMemoryCacheIndex.removeEntry(cacheEntry.key, cacheEntry.value);
        }
        return evictedValues;
    }

    private synchronized void increaseUsageCount(CacheEntry<K, V> cacheEntry) {
        AtomicInteger counter = this.mCachedEntries.get(cacheEntry);
        Preconditions.checkNotNull((Object)counter);
        counter.incrementAndGet();
    }

    private synchronized void decreaseUsageCount(CacheEntry<K, V> cacheEntry) {
        AtomicInteger counter = this.mCachedEntries.get(cacheEntry);
        Preconditions.checkNotNull((Object)counter);
        Preconditions.checkState((counter.get() > 0 ? 1 : 0) != 0);
        counter.decrementAndGet();
    }

    private synchronized boolean decreaseOrphansUsageCountAndMaybeRemove(CacheEntry<K, V> cacheEntry) {
        AtomicInteger counter = this.mOrphans.get(cacheEntry);
        Preconditions.checkNotNull((Object)counter);
        Preconditions.checkState((counter.get() > 0 ? 1 : 0) != 0);
        if (counter.decrementAndGet() == 0) {
            this.mOrphans.remove(cacheEntry);
            return true;
        }
        return false;
    }

    private synchronized void maybeAddToEvictionQueue(CacheEntry<K, V> cacheEntry) {
        AtomicInteger counter = this.mCachedEntries.get(cacheEntry);
        Preconditions.checkNotNull((Object)counter);
        Preconditions.checkArgument((!this.mEvictionQueue.contains(cacheEntry) ? 1 : 0) != 0);
        if (counter.get() == 0) {
            this.mEvictionQueueSize = (int)((long)this.mEvictionQueueSize + this.mValueInfoCallback.getSizeInBytes(cacheEntry.value.get()));
            this.mEvictionQueue.add(cacheEntry);
        }
    }

    private synchronized void removeFromEvictionQueue(CacheEntry<K, V> cacheEntry) {
        long valueSize = this.mValueInfoCallback.getSizeInBytes(cacheEntry.value.get());
        Preconditions.checkState(((long)this.mEvictionQueueSize >= valueSize ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.mEvictionQueue.remove(cacheEntry));
        this.mEvictionQueueSize = (int)((long)this.mEvictionQueueSize - valueSize);
    }

    private synchronized void putInCachedEntries(CacheEntry<K, V> cacheEntry) {
        Preconditions.checkState((!this.mCachedEntries.containsKey(cacheEntry) ? 1 : 0) != 0);
        this.mCachedValuesSize = (int)((long)this.mCachedValuesSize + this.mValueInfoCallback.getSizeInBytes(cacheEntry.value.get()));
        this.mCachedEntries.put(cacheEntry, new AtomicInteger());
    }

    private synchronized void removeFromCachedEntries(CacheEntry<K, V> cacheEntry) {
        long valueSize = this.mValueInfoCallback.getSizeInBytes(cacheEntry.value.get());
        Preconditions.checkState(((long)this.mCachedValuesSize >= valueSize ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.mCachedEntries.remove(cacheEntry));
        this.mCachedValuesSize = (int)((long)this.mCachedValuesSize - valueSize);
    }

    private synchronized void moveFromCachedEntriesToOrphans(CacheEntry<K, V> cacheEntry) {
        AtomicInteger counter = this.mCachedEntries.get(cacheEntry);
        this.removeFromCachedEntries(cacheEntry);
        this.mOrphans.put(cacheEntry, counter);
    }

    private synchronized CloseableReference<V> handleIndexRegistration(K key, CloseableReference<V> newReference) {
        CloseableReference<V> removedReference = this.mMemoryCacheIndex.addEntry(key, newReference);
        if (removedReference == null) {
            return null;
        }
        CacheEntry<K, V> removedWrappedReference = CacheEntry.of(key, removedReference);
        EntryState state = this.getEntryState(removedWrappedReference);
        switch (state) {
            case SHARED: {
                this.moveFromCachedEntriesToOrphans(removedWrappedReference);
                return null;
            }
            case EXCLUSIVELY_OWNED: {
                this.removeFromEvictionQueue(removedWrappedReference);
                this.removeFromCachedEntries(removedWrappedReference);
                return removedReference;
            }
        }
        Preconditions.checkState((boolean)false, (String)"MemoryCacheIndex returned value in invalid state %s", (Object[])new Object[]{state});
        return null;
    }

    private static int newEvictionQueueLimit(int currentTotal, int maxTotal, int currentEvictionQueue, int maxEvictionQueue) {
        int trimNeeded = Math.max(0, currentTotal - maxTotal);
        int afterTrim = Math.max(0, currentEvictionQueue - trimNeeded);
        return Math.min(maxEvictionQueue, afterTrim);
    }

    public static interface CacheTrimStrategy {
        public void trimCache(CountingMemoryCache<?, ?, ?> var1, MemoryTrimType var2);
    }

    public static interface ValueInfoCallback<V> {
        public long getSizeInBytes(V var1);
    }

    @VisibleForTesting
    static enum EntryState {
        NOT_CACHED,
        SHARED,
        EXCLUSIVELY_OWNED,
        ORPHAN;

    }

    @VisibleForTesting
    static class CacheEntry<K, V> {
        public final K key;
        public final CloseableReference<V> value;

        private CacheEntry(K key, CloseableReference<V> value) {
            this.key = Preconditions.checkNotNull(key);
            this.value = (CloseableReference)Preconditions.checkNotNull(value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ System.identityHashCode(this.value);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheEntry)) {
                return false;
            }
            CacheEntry other = (CacheEntry)o;
            return this.key.equals(other.key) && this.value == other.value;
        }

        @VisibleForTesting
        static <K, V> CacheEntry<K, V> of(K key, CloseableReference<V> value) {
            return new CacheEntry<K, V>(key, value);
        }
    }
}

