/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.datasource;

import android.graphics.Bitmap;
import com.facebook.common.internal.Lists;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListBitmapDataSubscriber
extends BaseDataSubscriber<List<CloseableReference<CloseableImage>>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewResultImpl(DataSource<List<CloseableReference<CloseableImage>>> dataSource) {
        if (!dataSource.isFinished()) {
            return;
        }
        List imageRefList = (List)dataSource.getResult();
        if (imageRefList == null) {
            this.onNewResultListImpl(null);
            return;
        }
        try {
            ArrayList bitmapList = Lists.newArrayListWithCapacity((int)imageRefList.size());
            for (CloseableReference closeableImageRef : imageRefList) {
                if (closeableImageRef != null && closeableImageRef.get() instanceof CloseableBitmap) {
                    bitmapList.add(((CloseableBitmap)closeableImageRef.get()).getUnderlyingBitmap());
                    continue;
                }
                bitmapList.add(null);
            }
            this.onNewResultListImpl(bitmapList);
        }
        finally {
            for (CloseableReference closeableImageRef : imageRefList) {
                CloseableReference.closeSafely((CloseableReference)closeableImageRef);
            }
        }
    }

    protected abstract void onNewResultListImpl(List<Bitmap> var1);
}

