/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.MemoryCacheProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.request.ImageRequest;

public class EncodedMemoryCacheProducer
extends MemoryCacheProducer<CacheKey, PooledByteBuffer> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "EncodedMemoryCacheProducer";

    public EncodedMemoryCacheProducer(MemoryCache<CacheKey, PooledByteBuffer, Void> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        super(memoryCache, cacheKeyFactory, nextProducer);
    }

    @Override
    protected CacheKey getCacheKey(ImageRequest imageRequest) {
        return this.mCacheKeyFactory.getEncodedCacheKey(imageRequest);
    }

    @Override
    protected boolean isResultFinal(CloseableReference<PooledByteBuffer> cachedResultFound) {
        return true;
    }

    @Override
    protected ImageRequest.RequestLevel getProducerRequestLevel() {
        return ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE;
    }

    @Override
    protected boolean shouldCacheReturnedValues() {
        return true;
    }

    @Override
    protected boolean shouldCacheResult(CloseableReference<PooledByteBuffer> result, CacheKey cacheKey, boolean isLast) {
        return isLast;
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

