/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.common.internal.Maps;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.MemoryCacheIndex;
import java.util.Map;
import javax.annotation.Nullable;

public class SimpleMemoryCacheIndex<K, V>
implements MemoryCacheIndex<K, V, Void> {
    private final Map<K, CloseableReference<V>> mMapIndex = Maps.newHashMap();

    @Override
    public synchronized CloseableReference<V> addEntry(K key, CloseableReference<V> value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        return this.mMapIndex.put(key, value);
    }

    @Override
    public synchronized CloseableReference<V> lookupValue(K key, @Nullable Void unused) {
        Preconditions.checkNotNull(key);
        return this.mMapIndex.get(key);
    }

    @Override
    public synchronized void removeEntry(K key, CloseableReference<V> value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        Preconditions.checkState((this.mMapIndex.remove(key) == value ? 1 : 0) != 0);
    }
}

