/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class LocalFileFetchProducer
extends LocalFetchProducer {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalFileFetchProducer";

    public LocalFileFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory) {
        super(executor, pooledByteBufferFactory);
    }

    @Override
    protected InputStream getInputStream(ImageRequest imageRequest) throws IOException {
        return new FileInputStream(imageRequest.getSourceFile());
    }

    @Override
    protected int getLength(ImageRequest imageRequest) {
        return (int)imageRequest.getSourceFile().length();
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

