/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.common.internal.Lists;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CountingMemoryCacheInspector<K, V> {
    private final CountingMemoryCache<K, V> mCountingBitmapCache;

    public CountingMemoryCacheInspector(CountingMemoryCache<K, V> countingBitmapCache) {
        this.mCountingBitmapCache = countingBitmapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DumpInfo dumpCacheContent() {
        CountingMemoryCache<K, V> countingMemoryCache = this.mCountingBitmapCache;
        synchronized (countingMemoryCache) {
            DumpInfo dumpInfo = new DumpInfo(this.mCountingBitmapCache.getSizeInBytes(), this.mCountingBitmapCache.getEvictionQueueSizeInBytes(), this.mCountingBitmapCache.mMemoryCacheParams);
            ArrayList cachedEntries = this.mCountingBitmapCache.mCachedEntries.getMatchingEntries(null);
            for (Map.Entry entry : cachedEntries) {
                CountingMemoryCache.Entry entry2 = (CountingMemoryCache.Entry)entry.getValue();
                DumpInfoEntry dumpEntry = new DumpInfoEntry(entry2.key, entry2.valueRef);
                if (entry2.clientCount > 0) {
                    dumpInfo.sharedEntries.add(dumpEntry);
                    continue;
                }
                dumpInfo.lruEntries.add(dumpEntry);
            }
            return dumpInfo;
        }
    }

    public static class DumpInfo<K, V> {
        public final int maxSize;
        public final int maxEntriesCount;
        public final int maxEntrySize;
        public final int size;
        public final int lruSize;
        public final List<DumpInfoEntry<K, V>> lruEntries;
        public final List<DumpInfoEntry<K, V>> sharedEntries;

        public DumpInfo(int size, int lruSize, MemoryCacheParams params) {
            this.maxSize = params.maxCacheSize;
            this.maxEntriesCount = params.maxCacheEntries;
            this.maxEntrySize = params.maxCacheEntrySize;
            this.size = size;
            this.lruSize = lruSize;
            this.lruEntries = Lists.newArrayList();
            this.sharedEntries = Lists.newArrayList();
        }

        public void release() {
            for (DumpInfoEntry<K, V> entry : this.lruEntries) {
                entry.release();
            }
            for (DumpInfoEntry<K, V> entry : this.sharedEntries) {
                entry.release();
            }
        }
    }

    public static class DumpInfoEntry<K, V> {
        public final K key;
        public final CloseableReference<V> value;

        public DumpInfoEntry(K key, CloseableReference<V> valueRef) {
            this.key = Preconditions.checkNotNull(key);
            this.value = CloseableReference.cloneOrNull(valueRef);
        }

        public void release() {
            CloseableReference.closeSafely(this.value);
        }
    }
}

