/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.webp;

import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.webp.WebPFrame;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WebPImage
implements AnimatedImage {
    private static volatile boolean sInitialized;
    @DoNotStrip
    private int mNativeContext;

    private static synchronized void ensure() {
        if (!sInitialized) {
            sInitialized = true;
            SoLoaderShim.loadLibrary((String)"webp");
            SoLoaderShim.loadLibrary((String)"webpimage");
        }
    }

    @DoNotStrip
    WebPImage(int nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    @Override
    public void dispose() {
        this.nativeDispose();
    }

    public static WebPImage create(byte[] source) {
        WebPImage.ensure();
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return WebPImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static WebPImage create(long nativePtr, int sizeInBytes) {
        WebPImage.ensure();
        Preconditions.checkArgument((nativePtr != 0L ? 1 : 0) != 0);
        return WebPImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes);
    }

    @Override
    public int getWidth() {
        return this.nativeGetWidth();
    }

    @Override
    public int getHeight() {
        return this.nativeGetHeight();
    }

    @Override
    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    @Override
    public int getDuration() {
        return this.nativeGetDuration();
    }

    @Override
    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    @Override
    public int getLoopCount() {
        return this.nativeGetLoopCount();
    }

    @Override
    public WebPFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    @Override
    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    @Override
    public boolean doesRenderSupportScaling() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        WebPFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), frame.shouldBlendWithPreviousFrame(), frame.shouldDisposeToBackgroundColor() ? AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND : AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT);
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    private static native WebPImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    private static native WebPImage nativeCreateFromNativeMemory(long var0, int var2);

    private native int nativeGetWidth();

    private native int nativeGetHeight();

    private native int nativeGetDuration();

    private native int nativeGetFrameCount();

    private native int[] nativeGetFrameDurations();

    private native int nativeGetLoopCount();

    private native WebPFrame nativeGetFrame(int var1);

    private native int nativeGetSizeInBytes();

    private native void nativeDispose();

    private native void nativeFinalize();
}

