/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import android.util.Pair;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imageutils.JfifUtil;
import javax.annotation.Nullable;

public class AddImageTransformMetaDataProducer
implements Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public AddImageTransformMetaDataProducer(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new AddImageTransformMetaDataConsumer(consumer), context);
    }

    private static int getRotationAngle(CloseableReference<PooledByteBuffer> inputRef) {
        return JfifUtil.getAutoRotateAngleFromOrientation(JfifUtil.getOrientation(new PooledByteBufferInputStream((PooledByteBuffer)inputRef.get())));
    }

    private class AddImageTransformMetaDataConsumer
    extends DelegatingConsumer<CloseableReference<PooledByteBuffer>, Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
        @Nullable
        private ImageTransformMetaData mMetaData;

        private AddImageTransformMetaDataConsumer(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer) {
            super(consumer);
            this.mMetaData = null;
        }

        @Override
        protected void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (newResult == null) {
                this.getConsumer().onNewResult(Pair.create(newResult, (Object)new ImageTransformMetaData.Builder().build()), isLast);
                return;
            }
            if (this.mMetaData == null || this.mMetaData.getImageFormat() == ImageFormat.UNKNOWN) {
                ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(new PooledByteBufferInputStream((PooledByteBuffer)newResult.get()));
                ImageTransformMetaData.Builder builder = new ImageTransformMetaData.Builder();
                builder.setImageFormat(imageFormat);
                boolean metaDataComplete = false;
                if (imageFormat != ImageFormat.JPEG) {
                    metaDataComplete = true;
                } else {
                    Rect dimensions = JfifUtil.getDimensions(new PooledByteBufferInputStream((PooledByteBuffer)newResult.get()));
                    if (dimensions != null) {
                        metaDataComplete = true;
                        builder.setWidth(dimensions.width());
                        builder.setHeight(dimensions.height());
                        builder.setRotationAngle(AddImageTransformMetaDataProducer.getRotationAngle((CloseableReference<PooledByteBuffer>)newResult));
                    }
                }
                if (metaDataComplete) {
                    this.mMetaData = builder.build();
                }
            }
            this.getConsumer().onNewResult(Pair.create(newResult, (Object)this.mMetaData), isLast);
        }
    }
}

