/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.os.SystemClock;
import com.facebook.common.executors.UiThreadExecutorService;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class JobScheduler<T, E> {
    private final Executor mExecutor;
    private final JobRunnable<T, E> mJobRunnable;
    private final Runnable mDoJobRunnable;
    private final Runnable mSubmitJobRunnable;
    private final int mMinimumJobIntervalMs;
    @GuardedBy(value="this")
    @VisibleForTesting
    CloseableReference<T> mInputRef;
    @Nullable
    @GuardedBy(value="this")
    @VisibleForTesting
    E mExtra;
    @GuardedBy(value="this")
    @VisibleForTesting
    boolean mIsLast;
    @GuardedBy(value="this")
    @VisibleForTesting
    JobState mJobState;
    @GuardedBy(value="this")
    @VisibleForTesting
    long mJobSubmitTime;
    @GuardedBy(value="this")
    @VisibleForTesting
    long mJobStartTime;

    public JobScheduler(Executor executor, JobRunnable<T, E> jobRunnable, int minimumJobIntervalMs) {
        this.mExecutor = executor;
        this.mJobRunnable = jobRunnable;
        this.mMinimumJobIntervalMs = minimumJobIntervalMs;
        this.mDoJobRunnable = new Runnable(){

            @Override
            public void run() {
                JobScheduler.this.doJob();
            }
        };
        this.mSubmitJobRunnable = new Runnable(){

            @Override
            public void run() {
                JobScheduler.this.submitJob();
            }
        };
        this.mInputRef = null;
        this.mIsLast = false;
        this.mJobState = JobState.IDLE;
        this.mJobSubmitTime = 0L;
        this.mJobStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJob() {
        CloseableReference<T> oldRef;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            oldRef = this.mInputRef;
            this.mInputRef = null;
            this.mExtra = null;
            this.mIsLast = false;
        }
        CloseableReference.closeSafely(oldRef);
    }

    public boolean updateJob(CloseableReference<T> inputRef, boolean isLast) {
        return this.updateJob(inputRef, null, isLast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateJob(CloseableReference<T> inputRef, @Nullable E extra, boolean isLast) {
        CloseableReference<T> oldRef;
        if (!JobScheduler.shouldProcess(inputRef, isLast)) {
            return false;
        }
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            oldRef = this.mInputRef;
            this.mInputRef = CloseableReference.cloneOrNull(inputRef);
            this.mExtra = extra;
            this.mIsLast = isLast;
        }
        CloseableReference.closeSafely(oldRef);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleJob() {
        long now = SystemClock.uptimeMillis();
        long when = 0L;
        boolean shouldEnqueue = false;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            if (!JobScheduler.shouldProcess(this.mInputRef, this.mIsLast)) {
                return false;
            }
            switch (this.mJobState) {
                case IDLE: {
                    when = Math.max(this.mJobStartTime + (long)this.mMinimumJobIntervalMs, now);
                    shouldEnqueue = true;
                    this.mJobSubmitTime = now;
                    this.mJobState = JobState.QUEUED;
                    break;
                }
                case QUEUED: {
                    break;
                }
                case RUNNING: {
                    this.mJobState = JobState.RUNNING_AND_PENDING;
                    break;
                }
            }
        }
        if (shouldEnqueue) {
            this.enqueueJob(when - now);
        }
        return true;
    }

    private void enqueueJob(long delay) {
        if (delay > 0L) {
            UiThreadExecutorService.getInstance().schedule(this.mSubmitJobRunnable, delay, TimeUnit.MILLISECONDS);
        } else {
            this.mSubmitJobRunnable.run();
        }
    }

    private void submitJob() {
        this.mExecutor.execute(this.mDoJobRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJob() {
        boolean isLast;
        E extra;
        CloseableReference<T> inputRef;
        long now = SystemClock.uptimeMillis();
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            inputRef = this.mInputRef;
            extra = this.mExtra;
            isLast = this.mIsLast;
            this.mInputRef = null;
            this.mExtra = null;
            this.mIsLast = false;
            this.mJobState = JobState.RUNNING;
            this.mJobStartTime = now;
        }
        try {
            if (JobScheduler.shouldProcess(inputRef, isLast)) {
                this.mJobRunnable.run(inputRef, extra, isLast);
            }
        }
        finally {
            CloseableReference.closeSafely(inputRef);
            this.onJobFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onJobFinished() {
        long now = SystemClock.uptimeMillis();
        long when = 0L;
        boolean shouldEnqueue = false;
        JobScheduler jobScheduler = this;
        synchronized (jobScheduler) {
            if (this.mJobState == JobState.RUNNING_AND_PENDING) {
                when = Math.max(this.mJobStartTime + (long)this.mMinimumJobIntervalMs, now);
                shouldEnqueue = true;
                this.mJobSubmitTime = now;
                this.mJobState = JobState.QUEUED;
            } else {
                this.mJobState = JobState.IDLE;
            }
        }
        if (shouldEnqueue) {
            this.enqueueJob(when - now);
        }
    }

    private static <T> boolean shouldProcess(CloseableReference<T> inputRef, boolean isLast) {
        return isLast || CloseableReference.isValid(inputRef);
    }

    public synchronized long getQueuedTime() {
        return this.mJobStartTime - this.mJobSubmitTime;
    }

    @VisibleForTesting
    static enum JobState {
        IDLE,
        QUEUED,
        RUNNING,
        RUNNING_AND_PENDING;

    }

    public static interface JobRunnable<T, E> {
        public void run(CloseableReference<T> var1, @Nullable E var2, boolean var3);
    }
}

