/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.net.Uri;
import android.provider.ContactsContract;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class LocalContentUriFetchProducer
extends LocalFetchProducer {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    private static final String DISPLAY_PHOTO_PATH = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"display_photo").getPath();
    private final ContentResolver mContentResolver;

    public LocalContentUriFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        super(executor, pooledByteBufferFactory);
        this.mContentResolver = contentResolver;
    }

    @Override
    protected InputStream getInputStream(ImageRequest imageRequest) throws IOException {
        Uri uri = imageRequest.getSourceUri();
        if (this.isContactUri(uri)) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.mContentResolver, (Uri)uri);
        }
        return this.mContentResolver.openInputStream(uri);
    }

    private boolean isContactUri(Uri uri) {
        return "com.android.contacts".equals(uri.getAuthority()) && !uri.getPath().startsWith(DISPLAY_PHOTO_PATH);
    }

    @Override
    protected int getLength(ImageRequest imageRequest) {
        return -1;
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

