/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public abstract class LocalFetchProducer
implements Producer<CloseableReference<PooledByteBuffer>> {
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;

    protected LocalFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<CloseableReference<PooledByteBuffer>> cancellableProducerRunnable = new StatefulProducerRunnable<CloseableReference<PooledByteBuffer>>(consumer, listener, this.getProducerName(), requestId){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected CloseableReference<PooledByteBuffer> getResult() throws Exception {
                try (InputStream inputStream = null;){
                    inputStream = LocalFetchProducer.this.getInputStream(imageRequest);
                    int length = LocalFetchProducer.this.getLength(imageRequest);
                    if (length < 0) {
                        CloseableReference closeableReference = CloseableReference.of((Closeable)LocalFetchProducer.this.mPooledByteBufferFactory.newByteBuffer(inputStream));
                        return closeableReference;
                    }
                    CloseableReference closeableReference = CloseableReference.of((Closeable)LocalFetchProducer.this.mPooledByteBufferFactory.newByteBuffer(inputStream, length));
                    return closeableReference;
                }
            }

            @Override
            protected void disposeResult(CloseableReference<PooledByteBuffer> result) {
                CloseableReference.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    protected abstract InputStream getInputStream(ImageRequest var1) throws IOException;

    protected abstract int getLength(ImageRequest var1);

    protected abstract String getProducerName();
}

