/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.nativecode.JpegTranscoder;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.ImageTransformMetaData;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class ResizeAndRotateProducer
implements Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
    private static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    @VisibleForTesting
    static final int DEFAULT_JPEG_QUALITY = 85;
    @VisibleForTesting
    static final int MAX_JPEG_SCALE_NUMERATOR = 8;
    @VisibleForTesting
    static final int MIN_TRANSFORM_INTERVAL_MS = 100;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> mNextProducer;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> nextProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new TransformingConsumer(consumer, context), context);
    }

    private static TriState shouldTransform(ImageRequest request, ImageTransformMetaData metaData) {
        if (metaData == null || metaData.getImageFormat() == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        if (metaData.getImageFormat() != ImageFormat.JPEG) {
            return TriState.NO;
        }
        return TriState.valueOf((ResizeAndRotateProducer.getRotationAngle(request, metaData) != 0 || ResizeAndRotateProducer.getScaleNumerator(request, metaData) != 8 ? 1 : 0) != 0);
    }

    private static int getScaleNumerator(ImageRequest imageRequest, ImageTransformMetaData metaData) {
        int heightAfterRotation;
        float heightRatio;
        ResizeOptions resizeOptions = imageRequest.getResizeOptions();
        if (resizeOptions == null) {
            return 8;
        }
        int rotationAngle = ResizeAndRotateProducer.getRotationAngle(imageRequest, metaData);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? metaData.getHeight() : metaData.getWidth();
        float widthRatio = (float)resizeOptions.width / (float)widthAfterRotation;
        int numerator = (int)Math.ceil(Math.max(widthRatio, heightRatio = (float)resizeOptions.height / (float)(heightAfterRotation = swapDimensions ? metaData.getWidth() : metaData.getHeight())) * 8.0f);
        if (numerator > 8) {
            return 8;
        }
        if (numerator < 1) {
            return 1;
        }
        return numerator;
    }

    private static int getRotationAngle(ImageRequest imageRequest, ImageTransformMetaData metaData) {
        if (!imageRequest.getAutoRotateEnabled()) {
            return 0;
        }
        int rotationAngle = metaData.getRotationAngle();
        Preconditions.checkArgument((rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270 ? 1 : 0) != 0);
        return rotationAngle;
    }

    private class TransformingConsumer
    extends DelegatingConsumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>, Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> {
        private final ProducerContext mProducerContext;
        private final JobScheduler<PooledByteBuffer, ImageTransformMetaData> mJobScheduler;

        public TransformingConsumer(Consumer<Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData>> consumer, ProducerContext producerContext) {
            super(consumer);
            this.mProducerContext = producerContext;
            JobScheduler.JobRunnable<PooledByteBuffer, ImageTransformMetaData> job = new JobScheduler.JobRunnable<PooledByteBuffer, ImageTransformMetaData>(){

                @Override
                public void run(CloseableReference<PooledByteBuffer> inputRef, ImageTransformMetaData metaData, boolean isLast) {
                    TransformingConsumer.this.doTransform((CloseableReference<PooledByteBuffer>)inputRef, metaData, isLast);
                }
            };
            this.mJobScheduler = new JobScheduler<PooledByteBuffer, ImageTransformMetaData>(ResizeAndRotateProducer.this.mExecutor, job, 100);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (TransformingConsumer.this.mProducerContext.isIntermediateResultExpected()) {
                        TransformingConsumer.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    TransformingConsumer.this.mJobScheduler.clearJob();
                }
            });
        }

        @Override
        protected void onNewResultImpl(@Nullable Pair<CloseableReference<PooledByteBuffer>, ImageTransformMetaData> newResult, boolean isLast) {
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, true);
                }
                return;
            }
            CloseableReference inputRef = (CloseableReference)newResult.first;
            ImageTransformMetaData metaData = (ImageTransformMetaData)newResult.second;
            TriState shouldTransform = ResizeAndRotateProducer.shouldTransform(this.mProducerContext.getImageRequest(), metaData);
            if (!isLast && shouldTransform == TriState.UNSET) {
                return;
            }
            if (shouldTransform != TriState.YES) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (!this.mJobScheduler.updateJob((CloseableReference<PooledByteBuffer>)inputRef, metaData, isLast)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTransform(CloseableReference<PooledByteBuffer> inputRef, ImageTransformMetaData metaData, boolean isLast) {
            Pair ret;
            this.mProducerContext.getListener().onProducerStart(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME);
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            try (PooledByteBufferOutputStream outputStream = ResizeAndRotateProducer.this.mPooledByteBufferFactory.newOutputStream();){
                JpegTranscoder.transcodeJpeg(new PooledByteBufferInputStream((PooledByteBuffer)inputRef.get()), outputStream, ResizeAndRotateProducer.getRotationAngle(imageRequest, metaData), ResizeAndRotateProducer.getScaleNumerator(imageRequest, metaData), 85);
                ret = Pair.create((Object)CloseableReference.of((Closeable)outputStream.toByteBuffer()), (Object)metaData);
            }
            this.mProducerContext.getListener().onProducerFinishWithSuccess(this.mProducerContext.getId(), ResizeAndRotateProducer.PRODUCER_NAME, null);
            this.getConsumer().onNewResult(ret, isLast);
        }
    }
}

