/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.GifFormatChecker;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import javax.annotation.Nullable;

public class ImageDecoder {
    private final AnimatedImageFactory mAnimatedImageFactory;
    private final PlatformBitmapFactory mBitmapFactoryWithPool;

    public ImageDecoder(AnimatedImageFactory animatedImageFactory, PlatformBitmapFactory bitmapFactoryWithPool) {
        this.mAnimatedImageFactory = animatedImageFactory;
        this.mBitmapFactoryWithPool = bitmapFactoryWithPool;
    }

    public CloseableImage decodeImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef, @Nullable ImageFormat imageFormat, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        if (imageFormat == null || imageFormat == ImageFormat.UNKNOWN) {
            imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(new PooledByteBufferInputStream((PooledByteBuffer)pooledByteBufferRef.get()));
        }
        switch (imageFormat) {
            case UNKNOWN: {
                throw new IllegalArgumentException("unknown image format");
            }
            case JPEG: {
                return this.decodeJpeg(pooledByteBufferRef, length, qualityInfo);
            }
            case GIF: {
                return this.decodeGif(pooledByteBufferRef, options);
            }
            case WEBP_ANIMATED: {
                return this.decodeAnimatedWebp(pooledByteBufferRef, options);
            }
        }
        return this.decodeStaticImage(pooledByteBufferRef);
    }

    public CloseableImage decodeGif(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageDecodeOptions options) {
        PooledByteBufferInputStream is = new PooledByteBufferInputStream((PooledByteBuffer)pooledByteBufferRef.get());
        if (GifFormatChecker.isAnimated(is)) {
            return this.mAnimatedImageFactory.decodeGif(pooledByteBufferRef, options);
        }
        return this.decodeStaticImage(pooledByteBufferRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableStaticBitmap decodeStaticImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef) {
        try (CloseableReference<Bitmap> bitmapReference = this.mBitmapFactoryWithPool.decodeFromPooledByteBuffer(pooledByteBufferRef);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, ImmutableQualityInfo.FULL_QUALITY);
            return closeableStaticBitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableStaticBitmap decodeJpeg(CloseableReference<PooledByteBuffer> pooledByteBufferRef, int length, QualityInfo qualityInfo) {
        try (CloseableReference<Bitmap> bitmapReference = this.mBitmapFactoryWithPool.decodeJPEGFromPooledByteBuffer(pooledByteBufferRef, length);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, qualityInfo);
            return closeableStaticBitmap;
        }
    }

    public CloseableImage decodeAnimatedWebp(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageDecodeOptions options) {
        return this.mAnimatedImageFactory.decodeWebP(pooledByteBufferRef, options);
    }
}

