/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@VisibleForTesting
class Bucket<V> {
    private static final String TAG = "com.facebook.imagepipeline.common.Bucket";
    public final int mItemSize;
    public final int mMaxLength;
    public final ConcurrentLinkedQueue<V> mFreeList;
    private int mInUseLength;

    public Bucket(int itemSize, int maxLength, int inUseLength) {
        Preconditions.checkState((itemSize > 0 ? 1 : 0) != 0);
        Preconditions.checkState((maxLength >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((inUseLength >= 0 ? 1 : 0) != 0);
        this.mItemSize = itemSize;
        this.mMaxLength = maxLength;
        this.mFreeList = new ConcurrentLinkedQueue();
        this.mInUseLength = inUseLength;
    }

    public boolean isMaxLengthExceeded() {
        return this.mInUseLength + this.mFreeList.size() > this.mMaxLength;
    }

    @Nullable
    public V get() {
        V value = this.pop();
        if (value != null) {
            ++this.mInUseLength;
        }
        return value;
    }

    @Nullable
    public V pop() {
        return this.mFreeList.poll();
    }

    public void incrementInUseCount() {
        ++this.mInUseLength;
    }

    public void release(V value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkState((this.mInUseLength > 0 ? 1 : 0) != 0);
        --this.mInUseLength;
        this.mFreeList.add(value);
    }

    public void decrementInUseCount() {
        Preconditions.checkState((this.mInUseLength > 0 ? 1 : 0) != 0);
        --this.mInUseLength;
    }

    public int getInUseCount() {
        return this.mInUseLength;
    }
}

