/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.NoOpMemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.DefaultBitmapPoolParams;
import com.facebook.imagepipeline.memory.DefaultByteArrayPoolParams;
import com.facebook.imagepipeline.memory.DefaultNativeMemoryChunkPoolParams;
import com.facebook.imagepipeline.memory.DefaultSharedByteArrayParams;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;

public class PoolConfig {
    private final PoolParams mBitmapPoolParams;
    private final PoolStatsTracker mBitmapPoolStatsTracker;
    private final PoolParams mCommonByteArrayPoolParams;
    private final PoolStatsTracker mCommonByteArrayPoolStatsTracker;
    private final MemoryTrimmableRegistry mMemoryTrimmableRegistry;
    private final PoolParams mNativeMemoryChunkPoolParams;
    private final PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
    private final PoolParams mSharedByteArrayParams;

    private PoolConfig(Builder builder) {
        this.mBitmapPoolParams = builder.mBitmapPoolParams == null ? DefaultBitmapPoolParams.get() : builder.mBitmapPoolParams;
        this.mBitmapPoolStatsTracker = builder.mBitmapPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mBitmapPoolStatsTracker;
        this.mCommonByteArrayPoolParams = builder.mCommonByteArrayPoolParams == null ? DefaultByteArrayPoolParams.get() : builder.mCommonByteArrayPoolParams;
        this.mCommonByteArrayPoolStatsTracker = builder.mCommonByteArrayPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mCommonByteArrayPoolStatsTracker;
        this.mMemoryTrimmableRegistry = builder.mMemoryTrimmableRegistry == null ? NoOpMemoryTrimmableRegistry.getInstance() : builder.mMemoryTrimmableRegistry;
        this.mNativeMemoryChunkPoolParams = builder.mNativeMemoryChunkPoolParams == null ? DefaultNativeMemoryChunkPoolParams.get() : builder.mNativeMemoryChunkPoolParams;
        this.mNativeMemoryChunkPoolStatsTracker = builder.mNativeMemoryChunkPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mNativeMemoryChunkPoolStatsTracker;
        this.mSharedByteArrayParams = builder.mSharedByteArrayParams == null ? DefaultSharedByteArrayParams.get() : builder.mSharedByteArrayParams;
    }

    public PoolParams getBitmapPoolParams() {
        return this.mBitmapPoolParams;
    }

    public PoolStatsTracker getBitmapPoolStatsTracker() {
        return this.mBitmapPoolStatsTracker;
    }

    public PoolParams getCommonByteArrayPoolParams() {
        return this.mCommonByteArrayPoolParams;
    }

    public PoolStatsTracker getCommonByteArrayPoolStatsTracker() {
        return this.mCommonByteArrayPoolStatsTracker;
    }

    public MemoryTrimmableRegistry getMemoryTrimmableRegistry() {
        return this.mMemoryTrimmableRegistry;
    }

    public PoolParams getNativeMemoryChunkPoolParams() {
        return this.mNativeMemoryChunkPoolParams;
    }

    public PoolStatsTracker getNativeMemoryChunkPoolStatsTracker() {
        return this.mNativeMemoryChunkPoolStatsTracker;
    }

    public PoolParams getSharedByteArrayParams() {
        return this.mSharedByteArrayParams;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PoolParams mBitmapPoolParams;
        private PoolStatsTracker mBitmapPoolStatsTracker;
        private PoolParams mCommonByteArrayPoolParams;
        private PoolStatsTracker mCommonByteArrayPoolStatsTracker;
        private MemoryTrimmableRegistry mMemoryTrimmableRegistry;
        private PoolParams mNativeMemoryChunkPoolParams;
        private PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
        private PoolParams mSharedByteArrayParams;

        private Builder() {
        }

        public Builder setBitmapPoolParams(PoolParams bitmapPoolParams) {
            this.mBitmapPoolParams = (PoolParams)Preconditions.checkNotNull((Object)bitmapPoolParams);
            return this;
        }

        public Builder setBitmapPoolStatsTracker(PoolStatsTracker bitmapPoolStatsTracker) {
            this.mBitmapPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)bitmapPoolStatsTracker);
            return this;
        }

        public Builder setCommonByteArrayPoolParams(PoolParams commonByteArrayPoolParams) {
            this.mCommonByteArrayPoolParams = (PoolParams)Preconditions.checkNotNull((Object)commonByteArrayPoolParams);
            return this;
        }

        public Builder setCommonByteArrayPoolStatsTracker(PoolStatsTracker commonByteArrayPoolStatsTracker) {
            this.mCommonByteArrayPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)commonByteArrayPoolStatsTracker);
            return this;
        }

        public Builder setMemoryTrimmableRegistry(MemoryTrimmableRegistry memoryTrimmableRegistry) {
            this.mMemoryTrimmableRegistry = memoryTrimmableRegistry;
            return this;
        }

        public Builder setNativeMemoryChunkPoolParams(PoolParams nativeMemoryChunkPoolParams) {
            this.mNativeMemoryChunkPoolParams = (PoolParams)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolParams);
            return this;
        }

        public Builder setNativeMemoryChunkPoolStatsTracker(PoolStatsTracker nativeMemoryChunkPoolStatsTracker) {
            this.mNativeMemoryChunkPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolStatsTracker);
            return this;
        }

        public Builder setSharedByteArrayParams(PoolParams sharedByteArrayParams) {
            this.mSharedByteArrayParams = sharedByteArrayParams;
            return this;
        }

        public PoolConfig build() {
            return new PoolConfig(this);
        }
    }
}

