/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BaseNetworkFetcher;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.FetchState;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.ProducerContext;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class HttpUrlConnectionNetworkFetcher
extends BaseNetworkFetcher<FetchState> {
    private static final int NUM_NETWORK_THREADS = 3;
    private final ExecutorService mExecutorService = Executors.newFixedThreadPool(3);

    @Override
    public FetchState createFetchState(Consumer<CloseableReference<PooledByteBuffer>> consumer, ProducerContext context) {
        return new FetchState(consumer, context);
    }

    @Override
    public void fetch(final FetchState fetchState, final NetworkFetcher.Callback callback) {
        final Future<?> future = this.mExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HttpURLConnection connection = null;
                Uri uri = fetchState.getUri();
                String scheme = uri.getScheme();
                String uriString = fetchState.getUri().toString();
                while (true) {
                    try {
                        String nextScheme;
                        URL url = new URL(uriString);
                        connection = (HttpURLConnection)url.openConnection();
                        String nextUriString = connection.getHeaderField("Location");
                        String string = nextScheme = nextUriString == null ? null : Uri.parse((String)nextUriString).getScheme();
                        if (nextUriString == null || nextScheme.equals(scheme)) {
                            InputStream is = connection.getInputStream();
                            callback.onResponse(is, -1);
                            break;
                        }
                        uriString = nextUriString;
                        scheme = nextScheme;
                        continue;
                    }
                    catch (Exception e) {
                        callback.onFailure(e);
                    }
                    finally {
                        if (connection == null) continue;
                        connection.disconnect();
                        continue;
                    }
                    break;
                }
            }
        });
        fetchState.getContext().addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                if (future.cancel(false)) {
                    callback.onCancellation();
                }
            }
        });
    }
}

