/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Throwables;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.TooManyBitmapsException;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapCounter;
import com.facebook.imagepipeline.memory.BitmapCounterProvider;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.SharedByteArray;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=11)
public class DalvikBitmapFactory {
    private final EmptyJpegGenerator mJpegGenerator;
    private final BitmapCounter mUnpooledBitmapsCounter;
    private final ResourceReleaser<Bitmap> mUnpooledBitmapsReleaser;
    private final SharedByteArray mSharedByteArray;
    private final boolean mDownsampleEnabled;

    public DalvikBitmapFactory(EmptyJpegGenerator jpegGenerator, SharedByteArray sharedByteArray, boolean downsampleEnabled) {
        this.mJpegGenerator = jpegGenerator;
        this.mSharedByteArray = sharedByteArray;
        this.mDownsampleEnabled = downsampleEnabled;
        this.mUnpooledBitmapsCounter = BitmapCounterProvider.get();
        this.mUnpooledBitmapsReleaser = new ResourceReleaser<Bitmap>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void release(Bitmap value) {
                try {
                    DalvikBitmapFactory.this.mUnpooledBitmapsCounter.decrease(value);
                }
                finally {
                    value.recycle();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> createBitmap(short width, short height) {
        try (CloseableReference<PooledByteBuffer> jpgRef = this.mJpegGenerator.generate(width, height);){
            CloseableReference<Bitmap> closeableReference;
            EncodedImage encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(ImageFormat.JPEG);
            try {
                CloseableReference<Bitmap> bitmapRef = this.decodeJPEGFromEncodedImage(encodedImage, ((PooledByteBuffer)jpgRef.get()).size());
                ((Bitmap)bitmapRef.get()).eraseColor(0);
                closeableReference = bitmapRef;
            }
            catch (Throwable throwable) {
                EncodedImage.closeSafely(encodedImage);
                throw throwable;
            }
            EncodedImage.closeSafely(encodedImage);
            return closeableReference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage) {
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
        int length = pooledByteBuffer.size();
        try {
            CloseableReference<Bitmap> closeableReference;
            CloseableReference<byte[]> encodedBytesArrayRef = this.mSharedByteArray.get(length);
            try {
                byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
                pooledByteBuffer.read(0, encodedBytesArray, 0, length);
                closeableReference = this.doDecodeBitmap(encodedBytesArray, length, encodedImage.getSampleSize());
            }
            catch (Throwable throwable) {
                CloseableReference.closeSafely(encodedBytesArrayRef);
                throw throwable;
            }
            CloseableReference.closeSafely(encodedBytesArrayRef);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, int length) {
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        try {
            CloseableReference<Bitmap> closeableReference;
            PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)bytesRef.get();
            Preconditions.checkArgument((length <= pooledByteBuffer.size() ? 1 : 0) != 0);
            CloseableReference<byte[]> encodedBytesArrayRef = this.mSharedByteArray.get(length + 2);
            try {
                byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
                pooledByteBuffer.read(0, encodedBytesArray, 0, length);
                if (!DalvikBitmapFactory.endsWithEOI(encodedBytesArray, length)) {
                    DalvikBitmapFactory.putEOI(encodedBytesArray, length);
                    length += 2;
                }
                closeableReference = this.doDecodeBitmap(encodedBytesArray, length, encodedImage.getSampleSize());
            }
            catch (Throwable throwable) {
                CloseableReference.closeSafely(encodedBytesArrayRef);
                throw throwable;
            }
            CloseableReference.closeSafely(encodedBytesArrayRef);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    private CloseableReference<Bitmap> doDecodeBitmap(byte[] encodedBytes, int length, int sampleSize) {
        Bitmap bitmap = DalvikBitmapFactory.decodeAsPurgeableBitmap(encodedBytes, length, sampleSize, this.mDownsampleEnabled);
        try {
            Bitmaps.pinBitmap(bitmap);
        }
        catch (Exception e) {
            bitmap.recycle();
            throw Throwables.propagate((Throwable)e);
        }
        if (!this.mUnpooledBitmapsCounter.increase(bitmap)) {
            bitmap.recycle();
            throw new TooManyBitmapsException();
        }
        return CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsReleaser);
    }

    @SuppressLint(value={"NewApi"})
    private static Bitmap decodeAsPurgeableBitmap(byte[] encodedBytes, int size, int sampleSize, boolean downsampleEnabled) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = true;
        options.inPreferredConfig = Bitmaps.BITMAP_CONFIG;
        options.inPurgeable = true;
        if (downsampleEnabled) {
            options.inSampleSize = sampleSize;
        }
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])encodedBytes, (int)0, (int)size, (BitmapFactory.Options)options);
        return (Bitmap)Preconditions.checkNotNull((Object)bitmap, (Object)"BitmapFactory returned null");
    }

    private static void putEOI(byte[] imageBytes, int offset) {
        imageBytes[offset] = -1;
        imageBytes[offset + 1] = -39;
    }

    private static boolean endsWithEOI(byte[] imageBytes, int length) {
        return length >= 2 && imageBytes[length - 2] == -1 && imageBytes[length - 1] == -39;
    }

    List<CloseableReference<Bitmap>> associateBitmapsWithBitmapCounter(List<Bitmap> bitmaps) {
        int countedBitmaps;
        try {
            for (countedBitmaps = 0; countedBitmaps < bitmaps.size(); ++countedBitmaps) {
                Bitmap bitmap = bitmaps.get(countedBitmaps);
                Bitmaps.pinBitmap(bitmap);
                if (this.mUnpooledBitmapsCounter.increase(bitmap)) continue;
                throw new TooManyBitmapsException();
            }
            ArrayList<CloseableReference<Bitmap>> ret = new ArrayList<CloseableReference<Bitmap>>();
            for (Bitmap bitmap : bitmaps) {
                ret.add((CloseableReference<Bitmap>)CloseableReference.of((Object)bitmap, this.mUnpooledBitmapsReleaser));
            }
            return ret;
        }
        catch (Exception exception) {
            if (bitmaps != null) {
                for (Bitmap bitmap : bitmaps) {
                    if (countedBitmaps-- > 0) {
                        this.mUnpooledBitmapsCounter.decrease(bitmap);
                    }
                    bitmap.recycle();
                }
            }
            throw Throwables.propagate((Throwable)exception);
        }
    }
}

