/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Rect;
import com.android.internal.util.Predicate;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.DiskCacheFactory;
import com.facebook.cache.disk.DiskStorageCache;
import com.facebook.common.executors.DefaultSerialExecutorService;
import com.facebook.common.executors.SerialExecutorService;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.internal.AndroidPredicates;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.time.MonotonicClock;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableOptions;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.factory.AnimatedDrawableFactory;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableCachingBackendImpl;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableCachingBackendImplProvider;
import com.facebook.imagepipeline.animated.util.AnimatedDrawableUtil;
import com.facebook.imagepipeline.cache.BitmapCountingMemoryCacheFactory;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheFactory;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.EncodedCountingMemoryCacheFactory;
import com.facebook.imagepipeline.cache.EncodedMemoryCacheFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ImagePipelineFactory {
    private static ImagePipelineFactory sInstance = null;
    private final ImagePipelineConfig mConfig;
    private AnimatedDrawableFactory mAnimatedDrawableFactory;
    private CountingMemoryCache<CacheKey, CloseableImage> mBitmapCountingMemoryCache;
    private MemoryCache<CacheKey, CloseableImage> mBitmapMemoryCache;
    private CountingMemoryCache<CacheKey, PooledByteBuffer> mEncodedCountingMemoryCache;
    private MemoryCache<CacheKey, PooledByteBuffer> mEncodedMemoryCache;
    private BufferedDiskCache mMainBufferedDiskCache;
    private DiskStorageCache mMainDiskStorageCache;
    private ImagePipeline mImagePipeline;
    private ProducerFactory mProducerFactory;
    private ProducerSequenceFactory mProducerSequenceFactory;
    private BufferedDiskCache mSmallImageBufferedDiskCache;
    private DiskStorageCache mSmallImageDiskStorageCache;

    public static ImagePipelineFactory getInstance() {
        return (ImagePipelineFactory)Preconditions.checkNotNull((Object)sInstance, (Object)"ImagePipelineFactory was not initialized!");
    }

    public static void initialize(Context context) {
        ImagePipelineFactory.initialize(ImagePipelineConfig.newBuilder(context).build());
    }

    public static void initialize(ImagePipelineConfig imagePipelineConfig) {
        sInstance = new ImagePipelineFactory(imagePipelineConfig);
    }

    public static void shutDown() {
        if (sInstance != null) {
            sInstance.getBitmapMemoryCache().removeAll((Predicate<CacheKey>)AndroidPredicates.True());
            sInstance.getEncodedMemoryCache().removeAll((Predicate<CacheKey>)AndroidPredicates.True());
            sInstance = null;
        }
    }

    public ImagePipelineFactory(ImagePipelineConfig config) {
        this.mConfig = (ImagePipelineConfig)Preconditions.checkNotNull((Object)config);
    }

    public CountingMemoryCache<CacheKey, CloseableImage> getBitmapCountingMemoryCache() {
        if (this.mBitmapCountingMemoryCache == null) {
            this.mBitmapCountingMemoryCache = BitmapCountingMemoryCacheFactory.get(this.mConfig.getBitmapMemoryCacheParamsSupplier(), this.mConfig.getMemoryTrimmableRegistry());
        }
        return this.mBitmapCountingMemoryCache;
    }

    public MemoryCache<CacheKey, CloseableImage> getBitmapMemoryCache() {
        if (this.mBitmapMemoryCache == null) {
            this.mBitmapMemoryCache = BitmapMemoryCacheFactory.get(this.getBitmapCountingMemoryCache(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mBitmapMemoryCache;
    }

    public CountingMemoryCache<CacheKey, PooledByteBuffer> getEncodedCountingMemoryCache() {
        if (this.mEncodedCountingMemoryCache == null) {
            this.mEncodedCountingMemoryCache = EncodedCountingMemoryCacheFactory.get(this.mConfig.getEncodedMemoryCacheParamsSupplier(), this.mConfig.getMemoryTrimmableRegistry());
        }
        return this.mEncodedCountingMemoryCache;
    }

    public MemoryCache<CacheKey, PooledByteBuffer> getEncodedMemoryCache() {
        if (this.mEncodedMemoryCache == null) {
            this.mEncodedMemoryCache = EncodedMemoryCacheFactory.get(this.getEncodedCountingMemoryCache(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mEncodedMemoryCache;
    }

    private BufferedDiskCache getMainBufferedDiskCache() {
        if (this.mMainBufferedDiskCache == null) {
            this.mMainBufferedDiskCache = new BufferedDiskCache(this.getMainDiskStorageCache(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(), this.mConfig.getPoolFactory().getPooledByteStreams(), this.mConfig.getExecutorSupplier().forLocalStorageRead(), this.mConfig.getExecutorSupplier().forLocalStorageWrite(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mMainBufferedDiskCache;
    }

    public DiskStorageCache getMainDiskStorageCache() {
        if (this.mMainDiskStorageCache == null) {
            this.mMainDiskStorageCache = DiskCacheFactory.newDiskStorageCache(this.mConfig.getMainDiskCacheConfig());
        }
        return this.mMainDiskStorageCache;
    }

    public ImagePipeline getImagePipeline() {
        if (this.mImagePipeline == null) {
            this.mImagePipeline = new ImagePipeline(this.getProducerSequenceFactory(), this.mConfig.getRequestListeners(), this.mConfig.getIsPrefetchEnabledSupplier(), this.getBitmapMemoryCache(), this.getEncodedMemoryCache(), this.mConfig.getCacheKeyFactory());
        }
        return this.mImagePipeline;
    }

    private ProducerFactory getProducerFactory() {
        if (this.mProducerFactory == null) {
            this.mProducerFactory = new ProducerFactory(this.mConfig.getContext(), this.mConfig.getPoolFactory().getSmallByteArrayPool(), this.mConfig.getImageDecoder(), this.mConfig.getProgressiveJpegConfig(), this.mConfig.isDownsampleEnabled(), this.mConfig.getExecutorSupplier(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(), this.getBitmapMemoryCache(), this.getEncodedMemoryCache(), this.getMainBufferedDiskCache(), this.getSmallImageBufferedDiskCache(), this.mConfig.getCacheKeyFactory(), this.mConfig.getPlatformBitmapFactory());
        }
        return this.mProducerFactory;
    }

    private ProducerSequenceFactory getProducerSequenceFactory() {
        if (this.mProducerSequenceFactory == null) {
            this.mProducerSequenceFactory = new ProducerSequenceFactory(this.getProducerFactory(), this.mConfig.getNetworkFetcher(), this.mConfig.isResizeAndRotateEnabledForNetwork());
        }
        return this.mProducerSequenceFactory;
    }

    public DiskStorageCache getSmallImageDiskStorageCache() {
        if (this.mSmallImageDiskStorageCache == null) {
            this.mSmallImageDiskStorageCache = DiskCacheFactory.newDiskStorageCache(this.mConfig.getSmallImageDiskCacheConfig());
        }
        return this.mSmallImageDiskStorageCache;
    }

    private BufferedDiskCache getSmallImageBufferedDiskCache() {
        if (this.mSmallImageBufferedDiskCache == null) {
            this.mSmallImageBufferedDiskCache = new BufferedDiskCache(this.getSmallImageDiskStorageCache(), this.mConfig.getPoolFactory().getPooledByteBufferFactory(), this.mConfig.getPoolFactory().getPooledByteStreams(), this.mConfig.getExecutorSupplier().forLocalStorageRead(), this.mConfig.getExecutorSupplier().forLocalStorageWrite(), this.mConfig.getImageCacheStatsTracker());
        }
        return this.mSmallImageBufferedDiskCache;
    }

    public AnimatedDrawableFactory getAnimatedDrawableFactory() {
        if (this.mAnimatedDrawableFactory == null) {
            final AnimatedDrawableUtil animatedDrawableUtil = new AnimatedDrawableUtil();
            RealtimeSinceBootClock monotonicClock = RealtimeSinceBootClock.get();
            DefaultSerialExecutorService serialExecutorService = new DefaultSerialExecutorService(this.mConfig.getExecutorSupplier().forDecode());
            ActivityManager activityManager = (ActivityManager)this.mConfig.getContext().getSystemService("activity");
            AnimatedDrawableCachingBackendImplProvider animatedDrawableCachingBackendImplProvider = new AnimatedDrawableCachingBackendImplProvider((SerialExecutorService)serialExecutorService, activityManager, animatedDrawableUtil, (MonotonicClock)monotonicClock){
                final /* synthetic */ SerialExecutorService val$serialExecutorService;
                final /* synthetic */ ActivityManager val$activityManager;
                final /* synthetic */ AnimatedDrawableUtil val$animatedDrawableUtil;
                final /* synthetic */ MonotonicClock val$monotonicClock;
                {
                    this.val$serialExecutorService = serialExecutorService;
                    this.val$activityManager = activityManager;
                    this.val$animatedDrawableUtil = animatedDrawableUtil;
                    this.val$monotonicClock = monotonicClock;
                }

                @Override
                public AnimatedDrawableCachingBackendImpl get(AnimatedDrawableBackend animatedDrawableBackend, AnimatedDrawableOptions options) {
                    return new AnimatedDrawableCachingBackendImpl(this.val$serialExecutorService, this.val$activityManager, this.val$animatedDrawableUtil, this.val$monotonicClock, animatedDrawableBackend, options);
                }
            };
            AnimatedDrawableBackendProvider backendProvider = new AnimatedDrawableBackendProvider(){

                @Override
                public AnimatedDrawableBackend get(AnimatedImageResult animatedImageResult, Rect bounds) {
                    return new AnimatedDrawableBackendImpl(animatedDrawableUtil, animatedImageResult, bounds);
                }
            };
            this.mAnimatedDrawableFactory = new AnimatedDrawableFactory(backendProvider, animatedDrawableCachingBackendImplProvider, animatedDrawableUtil, (ScheduledExecutorService)UiThreadImmediateExecutorService.getInstance(), this.mConfig.getContext().getResources());
        }
        return this.mAnimatedDrawableFactory;
    }
}

