/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import javax.annotation.concurrent.GuardedBy;

public class BitmapCounter {
    @GuardedBy(value="this")
    private int mCount;
    @GuardedBy(value="this")
    private long mSize;
    private final int mMaxCount;
    private final int mMaxSize;

    public BitmapCounter(int maxCount, int maxSize) {
        Preconditions.checkArgument((maxCount > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        this.mMaxCount = maxCount;
        this.mMaxSize = maxSize;
    }

    public synchronized boolean increase(Bitmap bitmap) {
        int bitmapSize = BitmapCounter.getBitmapSize(bitmap);
        if (this.mCount >= this.mMaxCount || this.mSize + (long)bitmapSize > (long)this.mMaxSize) {
            return false;
        }
        ++this.mCount;
        this.mSize += (long)bitmapSize;
        return true;
    }

    public synchronized void decrease(Bitmap bitmap) {
        int bitmapSize = BitmapCounter.getBitmapSize(bitmap);
        Preconditions.checkArgument(((long)bitmapSize <= this.mSize ? 1 : 0) != 0);
        Preconditions.checkArgument((this.mCount > 0 ? 1 : 0) != 0);
        this.mSize -= (long)bitmapSize;
        --this.mCount;
    }

    public synchronized int getCount() {
        return this.mCount;
    }

    public synchronized long getSize() {
        return this.mSize;
    }

    public static int getBitmapSize(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        return bitmap.getRowBytes() * bitmap.getHeight();
    }
}

