/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.Bucket;
import com.facebook.imagepipeline.memory.GenericByteArrayPool;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.OOMSoftReferenceBucket;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FlexByteArrayPool {
    private final ResourceReleaser<byte[]> mResourceReleaser;
    @VisibleForTesting
    final SoftRefByteArrayPool mDelegatePool;

    public FlexByteArrayPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams params, int maxNumThreads) {
        this.mDelegatePool = new SoftRefByteArrayPool(memoryTrimmableRegistry, params, NoOpPoolStatsTracker.getInstance(), maxNumThreads);
        this.mResourceReleaser = new ResourceReleaser<byte[]>(){

            public void release(byte[] unused) {
                FlexByteArrayPool.this.release(unused);
            }
        };
    }

    public CloseableReference<byte[]> get(int size) {
        return CloseableReference.of(this.mDelegatePool.get(size), this.mResourceReleaser);
    }

    public void release(byte[] value) {
        this.mDelegatePool.release(value);
    }

    public Map<String, Integer> getStats() {
        return this.mDelegatePool.getStats();
    }

    public int getMinBufferSize() {
        return this.mDelegatePool.getMinBufferSize();
    }

    @VisibleForTesting
    static class SoftRefByteArrayPool
    extends GenericByteArrayPool {
        private final int mMaxNumThreads;

        public SoftRefByteArrayPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker poolStatsTracker, int maxNumThreads) {
            super(memoryTrimmableRegistry, poolParams, poolStatsTracker);
            this.mMaxNumThreads = maxNumThreads;
        }

        @Override
        Bucket<byte[]> newBucket(int bucketedSize) {
            return new OOMSoftReferenceBucket<byte[]>(this.getSizeInBytes(bucketedSize), this.mMaxNumThreads, 0);
        }
    }
}

